/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomHeaderRenderer;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomTablePopupListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ColumnarTable
extends JTable {
    private static final int MAX_ROWS_DISPLAYED = 10;
    private Vector headerNames;
    private Vector tableNames;
    private Vector colNames;
    private Vector rowData;
    private DefaultListSelectionModel colSelectionModel;
    private TableColumnModel columnModel;
    private List listeners = null;
    private boolean displayTableNames;
    private boolean displayColumnNames;

    ColumnarTable(Vector headerNames, Vector rowData) {
        Vector firstrow = (Vector)headerNames.get(0);
        this.setModel(new DefaultTableModel(rowData, firstrow));
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(false);
        this.setShowVerticalLines(true);
        this.setAutoResizeMode(0);
        this.headerNames = headerNames;
        this.rowData = rowData;
        this.columnModel = this.getColumnModel();
        this.colSelectionModel = new DefaultListSelectionModel();
        this.colSelectionModel.setSelectionMode(2);
        this.columnModel.setSelectionModel(this.colSelectionModel);
        this.setSelectionMode(2);
        for (int i = 0; i < firstrow.size(); ++i) {
            Vector<String> rowHeader = new Vector<String>();
            for (int j = 0; j < headerNames.size(); ++j) {
                Vector header = (Vector)headerNames.get(j);
                rowHeader.add((String)header.get(i));
            }
            TableColumn column = this.columnModel.getColumn(i);
            column.setHeaderRenderer(new CustomHeaderRenderer(rowHeader));
            column.setPreferredWidth(85);
            column.setMinWidth(85);
        }
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                int index = ColumnarTable.this.columnModel.getColumnIndexAtX(me.getX());
                TableColumn column = ColumnarTable.this.columnModel.getColumn(index);
                CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
                if (chr.invertSelection()) {
                    DefaultListSelectionModel orig = null;
                    try {
                        orig = (DefaultListSelectionModel)ColumnarTable.this.colSelectionModel.clone();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (ColumnarTable.this.listeners != null) {
                        boolean refresh = false;
                        for (CustomTablePopupListener l : ColumnarTable.this.listeners) {
                            JDialog d = l.getPopupDialog();
                            d.setModal(true);
                            int w = d.getWidth();
                            int h = d.getHeight();
                            int xc = me.getX() + (int)me.getComponent().getLocationOnScreen().getX();
                            int yc = me.getY() + (int)me.getComponent().getLocationOnScreen().getY() - h / 2;
                            d.setBounds(xc, yc, w, h);
                            d.setVisible(true);
                            String t = l.getDisplayString();
                            if (t == null) continue;
                            chr.setExtraHeaderString(t);
                            chr.showExtraHeaderInfo(true);
                        }
                    }
                    ColumnarTable.this.colSelectionModel.addSelectionInterval(index, index);
                } else {
                    ColumnarTable.this.colSelectionModel.removeSelectionInterval(index, index);
                    chr.showExtraHeaderInfo(false);
                }
                int rows = ColumnarTable.this.rowData.size();
                if (rows > 0) {
                    ColumnarTable.this.setRowSelectionInterval(0, rows - 1);
                }
                ColumnarTable.this.getTableHeader().resizeAndRepaint();
            }
        });
    }

    private int getNumberOfRows(Vector rowData) {
        List t;
        int rows = 0;
        for (int i = 0; i < rowData.size() && ((t = (List)rowData.get(i)).size() <= rows || (rows = t.size()) < 10); ++i) {
        }
        return rows;
    }

    public List getColumnData(int colIdx) {
        if (colIdx >= this.getColumnCount()) {
            return null;
        }
        Iterator it = this.rowData.iterator();
        ArrayList ret = new ArrayList();
        while (it.hasNext()) {
            Vector row = (Vector)it.next();
            ret.add(row.get(colIdx));
        }
        return ret;
    }

    public Vector getColumnHeaderStrings(int colIdx) {
        if (colIdx >= this.getColumnCount()) {
            return null;
        }
        TableColumn column = this.columnModel.getColumn(colIdx);
        CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
        return chr.getColumnHeader();
    }

    public void setColumnHeaderStrings(int colIdx, Vector colHeader) {
        if (colIdx >= this.getColumnCount()) {
            return;
        }
        TableColumn column = this.columnModel.getColumn(colIdx);
        CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
        chr.setColumnHeader(colHeader);
    }

    public void setExtraColumnHeaderInfo(int colIdx, String info) {
        if (colIdx >= this.getColumnCount()) {
            return;
        }
        TableColumn column = this.columnModel.getColumn(colIdx);
        CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
        chr.setExtraColumnHeaderInfo(info);
    }

    public void setSelectedColumns(int[] selectedCols) {
        this.colSelectionModel.clearSelection();
        if (this.columnModel == null) {
            this.columnModel = this.getColumnModel();
        }
        for (int i = 0; i < selectedCols.length; ++i) {
            this.colSelectionModel.addSelectionInterval(selectedCols[i], selectedCols[i]);
            TableColumn column = this.columnModel.getColumn(selectedCols[i]);
            CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
            chr.setCheckboxSelected(true);
        }
        int rows = this.rowData.size();
        if (rows > 0) {
            this.setRowSelectionInterval(0, rows - 1);
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void processMouseEvent(MouseEvent me) {
    }

    public void processMouseMotionEvent(MouseEvent me) {
    }

    public void addPopupListener(CustomTablePopupListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }
}

