/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;

public class SavePackageCopyCommand
implements Command {
    private MorphoFrame morphoFrame = null;
    private AbstractDataPackage adp = null;
    private boolean showPackageFlag = true;

    public SavePackageCopyCommand() {
    }

    public SavePackageCopyCommand(AbstractDataPackage adp) {
        this.adp = adp;
    }

    public SavePackageCopyCommand(AbstractDataPackage adp, boolean showPackageFlag) {
        this.adp = adp;
        this.showPackageFlag = showPackageFlag;
    }

    public void execute(ActionEvent event) {
        DataViewContainerPanel dvcp = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            dvcp = this.morphoFrame.getDataViewContainerPanel();
        }
        if (dvcp != null) {
            this.adp = dvcp.getAbstractDataPackage();
        }
        Morpho morpho = Morpho.thisStaticInstance;
        String location = this.adp.getLocation();
        String oldid = this.adp.getPackageId();
        AccessionNumber an = new AccessionNumber(morpho);
        String nextid = an.getNextId();
        this.adp.setAccessionNumber(nextid);
        try {
            this.adp.serialize("local");
            this.adp.setLocation("local");
            this.adp.serializeData();
        }
        catch (MetacatUploadException e) {
            Log.debug(5, "Problem Saving Datapackage Locally");
        }
        if (this.showPackageFlag) {
            UIController.showNewPackage(this.adp);
        } else {
            MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
            morphoFrame.setVisible(false);
            UIController controller = UIController.getInstance();
            controller.removeWindow(morphoFrame);
            morphoFrame.dispose();
        }
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
            dataPackage.openDataPackage(location, oldid, null, null, null);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
        }
    }
}

