/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataObject {
    protected static Document doc;
    protected static Node root;
    protected Node metadataNode = null;
    protected Node metadataPathNode = null;
    protected String grammarType = "unknown";
    protected String grammar = "";

    public MetadataObject() {
    }

    public MetadataObject(Node node) {
        this.metadataNode = node;
    }

    public MetadataObject(Node node, String grammartype, String grammar) {
        this.metadataNode = node;
        this.grammar = grammar;
        this.grammarType = grammartype;
    }

    public MetadataObject(Node node, Node nd) {
        this.metadataNode = node;
        this.metadataPathNode = nd;
    }

    public MetadataObject(Node node, Node nd, String grammartype, String grammar) {
        this.metadataNode = node;
        this.metadataPathNode = nd;
        this.grammar = grammar;
        this.grammarType = grammartype;
    }

    public void setMetadataNode(Node nd) {
        this.metadataNode = nd;
    }

    public Node getMetadataNode() {
        return this.metadataNode;
    }

    public Node getMetadataPath() {
        return this.metadataPathNode;
    }

    public String getGrammar() {
        return this.grammar;
    }

    public void setGrammar(String grammar) {
        this.grammar = grammar;
    }

    public void setMetadataPath(Node nd) {
        this.metadataPathNode = nd;
    }

    public String getGenericValue(String genericName) {
        Node value = null;
        try {
            Log.debug(20, "genericName: " + genericName);
            value = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)genericName);
            if (value == null) {
                return "";
            }
        }
        catch (Exception e) {
            Log.debug(1, "Error in getGenericValue: " + e.toString());
        }
        String ret = "";
        if (value != null) {
            String path = value.getNodeValue();
            if (path != null && path.length() > 1) {
                Log.debug(30, "path: " + path);
                try {
                    try {
                        Log.debug(30, " Document root node has " + this.metadataNode.getAttributes().getLength() + " attributes");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    NodeList nl = XPathAPI.selectNodeList((Node)this.metadataNode, (String)path);
                    if (nl.getLength() == 0) {
                        Log.debug(30, "no nodes for " + path + " in " + this.metadataNode.toString());
                        return ret;
                    }
                    Node n = nl.item(0);
                    Node child = n.getFirstChild();
                    if (child != null) {
                        String s = child.getNodeValue();
                        if (s == null) {
                            return "";
                        }
                        s = s.trim();
                        return s;
                    }
                    return ret;
                }
                catch (Exception e) {
                    Log.debug(5, "error in XPath node selection in MetadataObject (getGenericValue)--- genericName: " + genericName);
                }
            }
        } else {
            return ret;
        }
        return ret;
    }

    public String getXPathValue(String path) {
        String ret = "";
        if (path != null && path.length() > 1) {
            try {
                NodeList nl = XPathAPI.selectNodeList((Node)this.metadataNode, (String)path);
                if (nl.getLength() == 0) {
                    return ret;
                }
                Node n = nl.item(0);
                Node child = n.getFirstChild();
                if (child != null) {
                    String s = child.getNodeValue();
                    if (s == null) {
                        return "";
                    }
                    s = s.trim();
                    return s;
                }
                return ret;
            }
            catch (Exception e) {
                Log.debug(5, "error in XPath node selection in MetadataObject (getXPathValue)");
            }
        }
        return ret;
    }

    public void setGenericValue(String genericName, String genericValue) {
        String path;
        Node value = null;
        try {
            value = XMLUtilities.getTextNodeWithXPath((Node)this.metadataPathNode, (String)genericName);
        }
        catch (Exception e) {
            Log.debug(10, "Error in getGenericValue: " + e.toString());
        }
        Log.debug(30, genericName + " maps to " + value);
        if (value != null && ((path = value.getNodeValue()) != null || path.length() < 1)) {
            try {
                Node child;
                Log.debug(30, "node path is " + path);
                NodeList nl = XPathAPI.selectNodeList((Node)this.metadataNode, (String)path);
                Node n = nl.item(0);
                if (n == null) {
                    Log.debug(5, "Unable to get node at " + path);
                }
                if ((child = n.getFirstChild()) != null) {
                    Log.debug(30, "setting value to " + genericValue);
                    child.setNodeValue(genericValue);
                }
            }
            catch (Exception e) {
                Log.debug(30, "error in setting XPath node in MetadataObject: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            root = XMLUtilities.getXMLAsDOMTreeRootNode((String)"/eml200KeymapConfig.xml");
            OrderedMap mp = XMLUtilities.getDOMTreeAsXPathMap((Node)root);
            System.out.println(mp.toString());
            XObject xobj = XPathAPI.eval((Node)root, (String)args[0]);
            Log.debug(1, "XObject evaluated: Type =" + xobj.getType());
            if (xobj.getType() == 1) {
                Log.debug(1, "XPath evaluation results in a BOOLEAN!     val: " + xobj.bool());
            }
            if (xobj.getType() == 4) {
                NodeList nl = XPathAPI.selectNodeList((Node)root, (String)args[0]);
                Log.debug(1, "Number of nodes: " + nl.getLength());
                Node n = nl.item(0);
                Node child = n.getFirstChild();
                if (child != null) {
                    String s = child.getNodeValue();
                    s = s.trim();
                    Log.debug(1, "Value is: " + s);
                } else {
                    Log.debug(1, "No value!!!");
                }
            }
        }
        catch (Exception e) {
            Log.debug(5, "error in XPath node selection in MetadataObject" + e.toString());
        }
    }

    public String toString() {
        return XMLUtilities.getDOMTreeAsString((Node)this.metadataNode);
    }
}

