/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportDataCommand
implements Command {
    private MorphoFrame morphoFrame = null;

    public void execute(ActionEvent event) {
        DataViewContainerPanel resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null) {
            final AbstractDataPackage adp = resultPane.getAbstractDataPackage();
            DataViewer dv = resultPane.getCurrentDataViewer();
            String entityId = null;
            if (dv != null) {
                entityId = dv.getEntityFileId();
            }
            Log.debug(20, "Action fired: Entity Wizard");
            DataPackageWizardInterface dpw = null;
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageWizardInterface.class);
                dpw = (DataPackageWizardInterface)((Object)provider);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
            }
            dpw.startEntityWizard(new DataPackageWizardListener(){

                public void wizardComplete(Node newDOM) {
                    if (newDOM != null) {
                        Log.debug(30, "Entity Wizard complete - creating Entity object..");
                        Node entNode = null;
                        String entityXpath = "";
                        try {
                            entityXpath = XMLUtilities.getTextNodeWithXPath((Node)adp.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entities").getNodeValue();
                            NodeList entityNodes = XMLUtilities.getNodeListWithXPath((Node)newDOM, (String)entityXpath);
                            entNode = entityNodes.item(0);
                        }
                        catch (Exception w) {
                            Log.debug(5, "Error in trying to get entNode in ImportDataCommand");
                        }
                        Entity entity = new Entity(entNode);
                        Log.debug(30, "Adding Entity object to AbstractDataPackage..");
                        adp.addEntity(entity);
                        adp.setLocation("");
                        try {
                            NodeList ameta = XMLUtilities.getNodeListWithXPath((Node)newDOM, (String)"/eml:eml/additionalMetadata");
                            if (ameta != null) {
                                for (int i = 0; i < ameta.getLength(); ++i) {
                                    Node ametaNode = ameta.item(i);
                                    Node movedNode = adp.getMetadataNode().getOwnerDocument().importNode(ametaNode, true);
                                    adp.getMetadataNode().appendChild(movedNode);
                                }
                            }
                        }
                        catch (Exception ee) {
                            Log.debug(5, "Error in trying to copy additionalMetadata" + ee.getMessage());
                        }
                    }
                    try {
                        ServiceController services = ServiceController.getInstance();
                        ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                        DataPackageInterface dataPackageInt = (DataPackageInterface)((Object)provider);
                        dataPackageInt.openNewDataPackage(adp, null);
                    }
                    catch (ServiceNotHandledException snhe) {
                        Log.debug(6, snhe.getMessage());
                    }
                    ImportDataCommand.this.morphoFrame.setVisible(false);
                    UIController controller = UIController.getInstance();
                    controller.removeWindow(ImportDataCommand.this.morphoFrame);
                    ImportDataCommand.this.morphoFrame.dispose();
                }

                public void wizardCanceled() {
                    Log.debug(45, "\n\n********** Wizard canceled!");
                }
            });
        }
    }
}

