/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.EditingCompleteListener;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.MetaDisplayFactoryInterface;
import edu.ucsb.nceas.morpho.plugins.MetaDisplayInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Base64;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeListener;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import edu.ucsb.nceas.morpho.util.StoreStateChangeEvent;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalSplitPaneUI;
import org.w3c.dom.Node;

public class DataViewContainerPanel
extends JPanel
implements MouseListener,
ChangeListener,
StateChangeListener,
StoreStateChangeEvent,
EditingCompleteListener {
    private static final String TOP_METAVIEW_TITLE = "Data Package Documentation";
    private static final String RIGHT_METAVIEW_TITLE = "Entity/Attribute";
    AbstractDataPackage adp;
    JPanel toppanel;
    private JPanel packagePanel;
    JTabbedPane tabbedEntitiesPanel;
    JPanel dataViewPanel;
    JPanel packageMetadataPanel;
    Morpho morpho;
    ConfigXML config;
    File[] entityFile;
    int lastTabSelected = 0;
    private DataViewer dv = null;
    Hashtable listValueHash = new Hashtable();
    JSplitPane entityPanel;
    JPanel entityMetadataPanel;
    JPanel currentDataPanel;
    JSplitPane vertSplit;
    Vector entityItems = null;
    PersistentVector lastPV = null;
    JLabel moreLabel;
    private static MetaDisplayFactoryInterface metaDisplayFactory = null;
    private ActionListener mdHideListener;
    private static final int METADATA_PANEL_DEFAULT_WIDTH = 675;
    private String currentURLInfo = null;
    private Vector storedStateChangeEventlist = new Vector();
    private DataViewer[] dvArray = null;

    public DataViewContainerPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.packageMetadataPanel = new JPanel();
        this.packageMetadataPanel.setLayout(new BorderLayout(0, 0));
        this.packageMetadataPanel.setMinimumSize(new Dimension(34, 34));
        this.entityMetadataPanel = new JPanel();
        this.entityMetadataPanel.setLayout(new BorderLayout(0, 0));
        this.dataViewPanel = new JPanel();
        this.dataViewPanel.setLayout(new BorderLayout(0, 0));
        JPanel AttributeMetadataPanel = new JPanel();
        this.tabbedEntitiesPanel = new JTabbedPane(3);
        this.tabbedEntitiesPanel.addMouseListener(new MouseAdapter(){
            String id = null;
            String item = null;
            MetaDisplayInterface mdi = null;
            TabbedContainer container = null;

            public void mouseReleased(MouseEvent me) {
                this.container = (TabbedContainer)DataViewContainerPanel.this.tabbedEntitiesPanel.getComponentAt(DataViewContainerPanel.this.lastTabSelected);
                this.mdi = this.container.getMetaDisplayInterface();
                this.item = (String)DataViewContainerPanel.this.entityItems.elementAt(DataViewContainerPanel.this.lastTabSelected);
                this.id = this.mdi.getIdentifier();
                try {
                    this.mdi.useTransformerProperty("displaymodule", "entity");
                    this.mdi.useTransformerProperty("entityindex", String.valueOf(DataViewContainerPanel.this.lastTabSelected + 1));
                    this.mdi.display(this.id);
                }
                catch (DocumentNotFoundException m) {
                    Log.debug(5, "Unable to display Entity:\n" + m.getMessage());
                }
                DataViewContainerPanel.this.resetTableSelection();
            }
        });
        JPanel entitiesContainerPanel = new JPanel();
        entitiesContainerPanel.setLayout(new BorderLayout(0, 0));
        entitiesContainerPanel.add("Center", this.tabbedEntitiesPanel);
        this.vertSplit = new JSplitPane(0, this.packageMetadataPanel, entitiesContainerPanel);
        if (UIManager.getSystemLookAndFeelClassName().indexOf("WindowsLookAndFeel") > -1) {
            this.vertSplit.setUI(new MetalSplitPaneUI());
        }
        SymComponent aSymComponent = new SymComponent();
        this.packageMetadataPanel.addComponentListener(aSymComponent);
        this.vertSplit.setOneTouchExpandable(true);
        this.add("Center", this.vertSplit);
        this.vertSplit.setDividerLocation(52);
        this.setVisible(true);
    }

    public DataViewContainerPanel(AbstractDataPackage adp) {
        this();
        this.adp = adp;
        JPanel packagePanel = new JPanel();
        packagePanel.setLayout(new BorderLayout(5, 5));
        this.entityItems = new Vector();
        int numEnts = 0;
        numEnts = adp.getEntityArray() == null ? 0 : adp.getEntityArray().length;
        for (int k = 0; k < numEnts; ++k) {
            this.entityItems.addElement(adp.getEntityName(k));
        }
        JLabel authorRefLabel = new JLabel(adp.getAuthor().trim() + ":    ");
        authorRefLabel.setFont(UISettings.TITLE_CITATION_FONT);
        JLabel titleRefLabel = new JLabel(adp.getTitle());
        titleRefLabel.setFont(UISettings.TITLE_CITATION_FONT_BOLD);
        JLabel accessionRefLabel = new JLabel("Accession Number: " + adp.getAccessionNumber() + " ");
        accessionRefLabel.setFont(UISettings.TITLE_CITATION_FONT_BOLD);
        JLabel keywordsRefLabel = new JLabel("Keywords: " + adp.getKeywords());
        keywordsRefLabel.setFont(UISettings.TITLE_CITATION_FONT);
        this.moreLabel = new JLabel("<html><a href=\".\"><b>more</b></a></html>");
        this.moreLabel.setCursor(new Cursor(12));
        this.moreLabel.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        this.moreLabel.addMouseListener(this);
        this.moreLabel.setToolTipText("Show more/less of package documentation");
        JPanel refPanelTop = new JPanel();
        refPanelTop.setPreferredSize(UISettings.TITLE_CITATION_DIMS);
        refPanelTop.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        refPanelTop.setLayout(new BorderLayout(0, 0));
        refPanelTop.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        JPanel refPanel = new JPanel();
        refPanel.setLayout(new GridLayout(3, 1));
        refPanel.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        JPanel refPanelLine1 = new JPanel();
        refPanelLine1.setLayout(new BorderLayout(0, 0));
        refPanelLine1.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        refPanelLine1.add("West", authorRefLabel);
        refPanelLine1.add("Center", titleRefLabel);
        JPanel refPanelLine2 = new JPanel();
        refPanelLine2.setLayout(new BorderLayout(0, 0));
        refPanelLine2.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        refPanelLine2.add("West", accessionRefLabel);
        refPanelLine2.add("Center", keywordsRefLabel);
        refPanel.add(refPanelLine1);
        refPanel.add(refPanelLine2);
        refPanel.add(this.moreLabel);
        refPanelTop.add("Center", refPanel);
        JPanel locationPanel = new JPanel();
        Border margin0 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        locationPanel.setPreferredSize(UISettings.TITLE_LOCATION_DIMS);
        locationPanel.setBorder(margin0);
        locationPanel.setBackground(UISettings.CUSTOM_GRAY);
        locationPanel.setOpaque(true);
        ImageIcon localIcon = new ImageIcon(this.getClass().getResource("local-package-small.png"));
        ImageIcon metacatIcon = new ImageIcon(this.getClass().getResource("network-package-small.png"));
        ImageIcon blankIcon = new ImageIcon(this.getClass().getResource("blank.gif"));
        JLabel localLabel = new JLabel("local");
        localLabel.setBackground(UISettings.CUSTOM_GRAY);
        localLabel.setOpaque(true);
        localLabel.setFont(UISettings.TITLE_LOCATION_FONT);
        localLabel.setIcon(localIcon);
        localLabel.setToolTipText("Package is stored locally");
        JLabel netLabel = new JLabel("net");
        netLabel.setBackground(UISettings.CUSTOM_GRAY);
        netLabel.setFont(UISettings.TITLE_LOCATION_FONT);
        netLabel.setOpaque(true);
        netLabel.setIcon(metacatIcon);
        netLabel.setToolTipText("Package is stored on the network");
        String location = adp.getLocation();
        if (location.equals("metacat")) {
            localLabel.setText("");
            localLabel.setIcon(blankIcon);
        } else if (location.equals("local")) {
            netLabel.setText("");
            netLabel.setIcon(blankIcon);
        } else if (!location.equals("localmetacat")) {
            localLabel.setText("");
            localLabel.setIcon(blankIcon);
            netLabel.setText("");
            netLabel.setIcon(blankIcon);
        }
        locationPanel.add("North", localLabel);
        locationPanel.add("South", netLabel);
        refPanelTop.add("East", locationPanel);
        packagePanel.add("North", refPanelTop);
        this.toppanel = packagePanel;
        this.setVisible(true);
    }

    public void init() {
        if (this.toppanel == null) {
            Log.debug(12, "toppanel is null");
        } else {
            this.packageMetadataPanel.removeAll();
            this.packageMetadataPanel.add("Center", this.toppanel);
        }
        if (this.entityItems == null || this.entityItems.size() == 0) {
            Log.debug(20, "EntityItems vector is null");
            this.vertSplit.removeAll();
            this.vertSplit.add(this.packageMetadataPanel);
            if (GUIAction.getMorphoFrameAncestor(this) == null) {
                this.storingStateChangeEvent(new StateChangeEvent(this, StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME));
            } else {
                StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(this, StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME));
            }
            this.moreLabel.setVisible(false);
            this.initDPMetaView(false);
            return;
        }
        this.entityFile = new File[this.entityItems.size()];
        for (int i = 0; i < this.entityItems.size(); ++i) {
            JSplitPane currentEntityPanel = this.createEntityPanel();
            String item = (String)this.entityItems.elementAt(i);
            String id = this.adp.getPackageId();
            if (id == null || id.equals("")) {
                id = "tempid";
            }
            JPanel currentEntityMetadataPanel = (JPanel)currentEntityPanel.getRightComponent();
            MetaDisplayInterface md = null;
            md = this.getMetaDisplayInstance();
            md.addEditingCompleteListener(this);
            md.setTitle(RIGHT_METAVIEW_TITLE);
            md.useTransformerProperty("displaymodule", "entity");
            md.useTransformerProperty("entityindex", "1");
            Component mdcomponent = null;
            try {
                mdcomponent = md.getDisplayComponent(id, this.adp, new MetaViewListener(currentEntityPanel));
            }
            catch (Exception m) {
                Log.debug(5, "Unable to display MetaData:\n" + m.getMessage());
                try {
                    mdcomponent = md.getDisplayComponent(this.adp, null);
                }
                catch (Exception e) {
                    Log.debug(15, "Error showing blank MetaData view:\n" + e.getMessage());
                    e.printStackTrace();
                }
            }
            currentEntityMetadataPanel.add("Center", mdcomponent);
            currentEntityPanel.setDividerLocation(675);
            TabbedContainer component = new TabbedContainer();
            component.setSplitPane(currentEntityPanel);
            component.setMetaDisplayInterface(md);
            component.setVisible(true);
            this.tabbedEntitiesPanel.addTab((String)this.entityItems.elementAt(i), component);
        }
        this.tabbedEntitiesPanel.addChangeListener(this);
        if (this.entityItems.size() > 0) {
            this.dvArray = new DataViewer[this.entityItems.size()];
            this.setDataViewer(0);
            StateChangeMonitor stateMonitor = StateChangeMonitor.getInstance();
            stateMonitor.addStateChangeListener(StateChangeEvent.SELECT_DATATABLE_COLUMN, this);
            stateMonitor.addStateChangeListener(StateChangeEvent.METAVIEWER_HISTORY_BACK, this);
            if (GUIAction.getMorphoFrameAncestor(this) == null) {
                this.storingStateChangeEvent(new StateChangeEvent(this, StateChangeEvent.CREATE_ENTITY_DATAPACKAGE_FRAME));
            } else {
                stateMonitor.notifyStateChange(new StateChangeEvent(this, StateChangeEvent.CREATE_ENTITY_DATAPACKAGE_FRAME));
            }
            this.initDPMetaView(true);
        } else {
            this.moreLabel.setEnabled(false);
            this.initDPMetaView(false);
        }
    }

    private void initDPMetaView(boolean hasData) {
        MetaDisplayInterface md = this.getMetaDisplayInstance();
        md.addEditingCompleteListener(this);
        md.setTitle(TOP_METAVIEW_TITLE);
        Component mdcomponent = null;
        if (hasData) {
            StringBuffer suppressBuff = new StringBuffer();
            Object nextAttributeFileID = null;
            Object nextDataFileID = null;
            Object nextEntityID = null;
            Object nextObj2 = null;
            for (Object nextObj2 : this.entityItems) {
                if (nextObj2 == null || nextObj2 instanceof String) continue;
            }
            md.useTransformerProperty("suppress_subjects_identifier", suppressBuff.toString());
            md.useTransformerProperty("suppress_objects_identifier", suppressBuff.toString());
        } else {
            this.moreLabel.setText("<html><a href=\".\"><b>less</b></a></html>");
            this.vertSplit.setDividerLocation(1.0);
        }
        try {
            String tempid = this.adp.getPackageId();
            if (tempid == null || tempid.equals("")) {
                tempid = "tempid";
            }
            mdcomponent = md.getDisplayComponent(tempid, this.adp, new MetaViewListener(this.vertSplit));
        }
        catch (Exception m) {
            Log.debug(30, "Unable to display Datapackage MetaData:\n" + m.getMessage());
            try {
                mdcomponent = md.getDisplayComponent(this.adp, null);
                this.moreLabel.setText("<html><a href=\".\"><b>less</b></a></html>");
                this.vertSplit.setDividerLocation(1.0);
            }
            catch (Exception e) {
                Log.debug(15, "Error showing blank MetaData view:\n" + e.getMessage());
                e.printStackTrace();
            }
        }
        this.toppanel.add("Center", mdcomponent);
    }

    public void setFramework(Morpho cf) {
        this.morpho = cf;
    }

    public Morpho getFramework() {
        return this.morpho;
    }

    public DataViewer getCurrentDataViewer() {
        return this.dv;
    }

    public void setTopPanel(JPanel jp) {
        this.toppanel = jp;
        this.toppanel.setVisible(true);
    }

    public void setEntityItems(Vector ei) {
        this.entityItems = ei;
    }

    public void setListValueHash(Hashtable ht) {
        this.listValueHash = ht;
    }

    public void removePVObject() {
        if (this.lastPV != null) {
            this.lastPV.delete();
        }
    }

    public void handleStateChange(StateChangeEvent event) {
        if (event.getChangedState().equals(StateChangeEvent.SELECT_DATATABLE_COLUMN)) {
            if (event.getSource() instanceof JTable) {
                this.showDataViewAndAttributePanel(((JTable)event.getSource()).getSelectedColumn());
            } else {
                this.showDataViewAndAttributePanel(0);
            }
        }
        if (event.getChangedState().equals(StateChangeEvent.METAVIEWER_HISTORY_BACK) && this.dv != null && this.tabbedEntitiesPanel != null && this.dv.getDataTable() != null) {
            TabbedContainer container = (TabbedContainer)this.tabbedEntitiesPanel.getComponentAt(this.lastTabSelected);
            String newID = container.getMetaDisplayInterface().getIdentifier();
            Log.debug(50, "newID=" + newID);
            String item = (String)this.entityItems.elementAt(this.lastTabSelected);
            String entityID = this.getEntityIDForThisEntityName(item);
            if (newID.equalsIgnoreCase(entityID)) {
                this.resetTableSelection();
            } else {
                String selectedAttribs = container.getMetaDisplayInterface().getTransformerProperty("attributeindex");
                if (selectedAttribs == null) {
                    this.resetTableSelection();
                    return;
                }
                int selectedColIndex = -1;
                try {
                    selectedColIndex = Integer.parseInt(selectedAttribs);
                }
                catch (NumberFormatException nfe) {
                    Log.debug(12, "Can't handle multiple column selections yet!!");
                    return;
                }
                this.dv.getDataTable().setColumnSelectionInterval(selectedColIndex - 1, selectedColIndex - 1);
                Log.debug(50, "& & & & & & & & & & selectedAttribs=" + selectedAttribs + ";\n selectedColIndex = " + selectedColIndex);
            }
        }
    }

    private void resetTableSelection() {
        JTable table;
        if (this.dv != null && this.dv.getDataTable() != null && (table = this.dv.getDataTable()).getRowCount() > 0 && table.getColumnCount() > 0) {
            table.setRowSelectionInterval(0, 0);
            table.setColumnSelectionInterval(0, 0);
        }
    }

    private String getEntityIDForThisEntityName(String entityName) {
        return (String)this.listValueHash.get(entityName);
    }

    public void saveDataChanges() {
        if (this.dvArray != null) {
            for (int i = 0; i < this.dvArray.length; ++i) {
                if (this.dvArray[i] == null) continue;
                boolean changeFlag = this.dvArray[i].getDataChangedFlag();
                if (changeFlag) {
                    this.dvArray[i].saveCurrentTable(false);
                    this.adp.setLocation("");
                }
                this.dvArray[i].setDataChangedFlag(false);
            }
        }
    }

    public void removeDataChanges() {
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        this.adp = morphoFrame.getAbstractDataPackage();
        boolean local = false;
        boolean metacat = false;
        if (this.adp.getLocation().equals("local")) {
            local = true;
        } else if (this.adp.getLocation().equals("metacat")) {
            metacat = true;
        } else {
            local = true;
            metacat = true;
        }
        AbstractDataPackage tempAdp = null;
        Entity[] entArray = null;
        try {
            tempAdp = DataPackageFactory.getDataPackage(this.adp.getAccessionNumber(), metacat, local);
            entArray = tempAdp.getEntityArray();
        }
        catch (Exception e) {
            Log.debug(20, "Unable to read the file in RevertCommand.java");
        }
        if (this.dvArray != null) {
            for (int i = 0; i < this.dvArray.length; ++i) {
                if (this.dvArray[i] == null) continue;
                int entityIndex = this.dvArray[i].getEntityIndex();
                if (tempAdp != null && tempAdp.getAttributeCountForAnEntity(entityIndex) != this.adp.getAttributeCountForAnEntity(entityIndex)) {
                    this.adp.deleteEntity(entityIndex);
                    this.adp.insertEntity(entArray[entityIndex], entityIndex);
                }
                this.dvArray[i].init();
            }
        }
    }

    private void setDataViewer(int index) {
        block33: {
            block27: {
                File displayFile;
                block26: {
                    block29: {
                        String protocol;
                        String urlinfo;
                        block30: {
                            block28: {
                                if (this.dvArray[this.lastTabSelected] != null) {
                                    boolean fg = this.dvArray[this.lastTabSelected].getDataChangedFlag();
                                }
                                if (this.dvArray[index] != null) break block27;
                                displayFile = null;
                                TabbedContainer comp = (TabbedContainer)this.tabbedEntitiesPanel.getComponentAt(this.lastTabSelected);
                                JSplitPane entireDataPanel = comp.getSplitPane();
                                JPanel currentDataPanelOld = (JPanel)entireDataPanel.getLeftComponent();
                                currentDataPanelOld.removeAll();
                                this.lastTabSelected = index;
                                Object dataId = null;
                                if (this.adp == null) {
                                    Log.debug(1, "adp is null! No data package");
                                    return;
                                }
                                String inline = this.adp.getDistributionInlineData(index, 0, 0);
                                if (inline.length() <= 0) break block28;
                                String encMethod = this.adp.getEncodingMethod(index, 0);
                                if (encMethod.indexOf("Base64") > -1 || encMethod.indexOf("base64") > -1 || encMethod.indexOf("Base 64") > -1 || encMethod.indexOf("base 64") > -1) {
                                    byte[] decodedData = Base64.decode(inline);
                                    ByteArrayInputStream bais = new ByteArrayInputStream(decodedData);
                                    InputStreamReader isr = new InputStreamReader(bais);
                                    FileSystemDataStore fds3 = new FileSystemDataStore(this.morpho);
                                    displayFile = fds3.saveTempDataFile(this.adp.getAccessionNumber(), isr);
                                } else {
                                    FileSystemDataStore fds2 = new FileSystemDataStore(this.morpho);
                                    StringReader sr2 = new StringReader(inline);
                                    displayFile = fds2.saveTempDataFile(this.adp.getAccessionNumber(), sr2);
                                }
                                break block26;
                            }
                            if (this.adp.getDistributionUrl(index, 0, 0).length() <= 0) break block29;
                            this.currentURLInfo = urlinfo = this.adp.getDistributionUrl(index, 0, 0);
                            int indx2 = urlinfo.indexOf("//");
                            protocol = urlinfo.substring(0, indx2);
                            if (!protocol.equals("ecogrid:")) break block30;
                            if (indx2 > -1) {
                                urlinfo = urlinfo.substring(indx2 + 2);
                            }
                            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                                urlinfo = urlinfo.substring(indx2 + 1);
                            }
                            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                                urlinfo = urlinfo.substring(0, indx2);
                            }
                            if (urlinfo.length() == 0) {
                                return;
                            }
                            try {
                                String loc;
                                block32: {
                                    block31: {
                                        loc = this.adp.location;
                                        if (loc.equals("local")) break block31;
                                        if (!loc.equals("localmetacat")) break block32;
                                    }
                                    FileSystemDataStore fds = new FileSystemDataStore(this.morpho);
                                    displayFile = fds.openFile(urlinfo);
                                    break block26;
                                }
                                if (loc.equals("metacat")) {
                                    MetacatDataStore mds = new MetacatDataStore(this.morpho);
                                    displayFile = mds.openDataFile(urlinfo);
                                    break block26;
                                }
                                if (!loc.equals("")) break block26;
                                try {
                                    ConfigXML profile = this.morpho.getProfile();
                                    String separator = profile.get("separator", 0);
                                    separator = separator.trim();
                                    FileSystemDataStore fds = new FileSystemDataStore(this.morpho);
                                    String temp = new String();
                                    temp = urlinfo.substring(0, urlinfo.indexOf(separator));
                                    temp = temp + "/" + urlinfo.substring(urlinfo.indexOf(separator) + 1, urlinfo.length());
                                    displayFile = fds.openTempFile(temp);
                                    break block26;
                                }
                                catch (Exception q1) {
                                    try {
                                        FileSystemDataStore fds = new FileSystemDataStore(this.morpho);
                                        displayFile = fds.openFile(urlinfo);
                                        break block26;
                                    }
                                    catch (Exception q2) {
                                        try {
                                            MetacatDataStore mds = new MetacatDataStore(this.morpho);
                                            displayFile = mds.openDataFile(urlinfo);
                                            break block26;
                                        }
                                        catch (Exception q3) {
                                            Log.debug(5, "Exception opening datafile after trying all sources!");
                                        }
                                    }
                                }
                            }
                            catch (Exception q) {
                                Log.debug(5, "Exception opening file!");
                                q.printStackTrace();
                            }
                            break block26;
                        }
                        if (protocol.equals("http:")) {
                            Log.debug(20, "urlinfo: " + urlinfo);
                        } else {
                            Log.debug(20, "protocol: " + protocol);
                        }
                        break block26;
                    }
                    if (this.adp.getDistributionArray(index, 0) == null) {
                        // empty if block
                    }
                }
                this.dv = new DataViewer(this.morpho, "DataFile: ", null);
                this.dv.setAbstractDataPackage(this.adp);
                this.dv.setEntityIndex(index);
                this.dv.setDataFile(displayFile);
                this.dv.setCurrentURLInfo(this.currentURLInfo);
                this.dv.init();
                this.dvArray[index] = this.dv;
                break block33;
            }
            this.lastTabSelected = index;
            this.dv = this.dvArray[index];
        }
        this.lastPV = this.dv.getPV();
        JPanel tablePanel = null;
        tablePanel = this.dv.DataViewerPanel;
        tablePanel.setOpaque(true);
        tablePanel.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        TabbedContainer compn = (TabbedContainer)this.tabbedEntitiesPanel.getComponentAt(index);
        JSplitPane entireDataPane = compn.getSplitPane();
        JPanel currentDataPanel = (JPanel)entireDataPane.getLeftComponent();
        currentDataPanel.setLayout(new BorderLayout(0, 0));
        currentDataPanel.add("Center", tablePanel);
        currentDataPanel.setBackground(UISettings.NONEDITABLE_BACKGROUND_COLOR);
        if (GUIAction.getMorphoFrameAncestor(this) == null) {
            Vector eventList = this.dv.getStoredStateChangeEvent();
            if (eventList != null) {
                for (int i = 0; i < eventList.size(); ++i) {
                    StateChangeEvent eventInKid = (StateChangeEvent)eventList.elementAt(i);
                    this.storingStateChangeEvent(eventInKid);
                }
            }
        } else {
            this.dv.broadcastStoredStateChangeEvent();
        }
    }

    private JSplitPane createEntityPanel() {
        JPanel entityMetadataPanel = new JPanel();
        entityMetadataPanel.setLayout(new BorderLayout(0, 0));
        this.dataViewPanel = new JPanel();
        this.dataViewPanel.setLayout(new BorderLayout(0, 0));
        this.entityPanel = new JSplitPane(1, this.dataViewPanel, entityMetadataPanel);
        if (UIManager.getSystemLookAndFeelClassName().indexOf("WindowsLookAndFeel") > -1) {
            this.entityPanel.setUI(new MetalSplitPaneUI());
        }
        this.entityPanel.setOneTouchExpandable(true);
        this.entityPanel.setDividerLocation(700);
        return this.entityPanel;
    }

    private void showDataViewAndAttributePanel(int selectedColIndex) {
        TabbedContainer container = (TabbedContainer)this.tabbedEntitiesPanel.getComponentAt(this.lastTabSelected);
        MetaDisplayInterface meta = container.getMetaDisplayInterface();
        String item = (String)this.entityItems.elementAt(this.lastTabSelected);
        String id = this.getEntityIDForThisEntityName(item);
        String identifier = meta.getIdentifier();
        try {
            meta.useTransformerProperty("displaymodule", "attributedetail");
            meta.useTransformerProperty("entityindex", String.valueOf(this.lastTabSelected + 1));
            meta.useTransformerProperty("attributeindex", String.valueOf(selectedColIndex + 1));
            meta.display(identifier);
        }
        catch (DocumentNotFoundException m) {
            Log.debug(5, "Unable to display Attribute:\n" + m.getMessage());
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object object = event.getSource();
        if (object == this.tabbedEntitiesPanel) {
            int k = this.tabbedEntitiesPanel.getSelectedIndex();
            this.setDataViewer(k);
        }
    }

    private MetaDisplayInterface getMetaDisplayInstance() {
        if (metaDisplayFactory == null) {
            ServiceProvider provider = null;
            try {
                ServiceController services = ServiceController.getInstance();
                provider = services.getServiceProvider(MetaDisplayFactoryInterface.class);
            }
            catch (ServiceNotHandledException ee) {
                Log.debug(0, "Error acquiring MetaDisplay plugin: " + ee);
                ee.printStackTrace();
                return null;
            }
            metaDisplayFactory = (MetaDisplayFactoryInterface)((Object)provider);
        }
        return metaDisplayFactory.getInstance();
    }

    public void storingStateChangeEvent(StateChangeEvent event) {
        if (this.storedStateChangeEventlist != null) {
            this.storedStateChangeEventlist.add(event);
        }
    }

    public Vector getStoredStateChangeEvent() {
        return this.storedStateChangeEventlist;
    }

    public void broadcastStoredStateChangeEvent() {
        if (this.storedStateChangeEventlist != null) {
            for (int i = 0; i < this.storedStateChangeEventlist.size(); ++i) {
                StateChangeEvent event = (StateChangeEvent)this.storedStateChangeEventlist.elementAt(i);
                StateChangeMonitor.getInstance().notifyStateChange(event);
            }
        }
    }

    public AbstractDataPackage getAbstractDataPackage() {
        return this.adp;
    }

    public int getLastTabSelected() {
        return this.lastTabSelected;
    }

    public String getPackageLocation() {
        AbstractDataPackage adp = this.getAbstractDataPackage();
        return adp.getLocation();
    }

    public void editingCompleted(String xmlString, String id, String location) {
        Log.debug(20, "editing complete: id: " + id + " location: " + location);
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        morphoFrame.setVisible(false);
        UIController uicontroller = UIController.getInstance();
        try {
            StringReader sr = new StringReader(xmlString);
            Node nd = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)sr);
            AbstractDataPackage newadp = DataPackageFactory.getDataPackage(nd);
            newadp.setLocation("");
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            DataPackageInterface dataPackageInt = (DataPackageInterface)((Object)provider);
            dataPackageInt.openNewDataPackage(newadp, null);
            uicontroller.removeWindow(morphoFrame);
            morphoFrame.dispose();
        }
        catch (Exception e) {
            Log.debug(5, "Exception in converting edited XML to DOM!" + e.getMessage());
        }
    }

    public void editingCanceled(String xmlString, String id, String location) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        String temp = this.moreLabel.getText();
        if (temp.indexOf("more") > -1) {
            this.moreLabel.setText("<html><a href=\".\"><b>less</b></a></html>");
            this.vertSplit.setDividerLocation(1.0);
        } else {
            this.moreLabel.setText("<html><a href=\".\"><b>more</b></a></html>");
            this.vertSplit.setDividerLocation(52);
        }
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == DataViewContainerPanel.this.packageMetadataPanel) {
                int cursize = DataViewContainerPanel.this.vertSplit.getDividerLocation();
                int maxsize = DataViewContainerPanel.this.vertSplit.getMaximumDividerLocation();
                if (maxsize - cursize < 1) {
                    DataViewContainerPanel.this.moreLabel.setText("<html><a href=\".\"><b>less</b></a></html>");
                } else {
                    DataViewContainerPanel.this.moreLabel.setText("<html><a href=\".\"><b>more</b></a></html>");
                }
            }
        }
    }

    class MetaViewListener
    implements ActionListener {
        private JSplitPane entitySplitPane;

        MetaViewListener(JSplitPane splitPane) {
            this.entitySplitPane = splitPane;
        }

        public void actionPerformed(ActionEvent e) {
            int closedPosition = 0;
            if (e.getID() == 30) {
                if (this.entitySplitPane.getOrientation() == 0) {
                    closedPosition = 52;
                    Log.debug(50, "VERTICAL_SPLIT, closedPosition=" + closedPosition);
                    DataViewContainerPanel.this.moreLabel.setText("<html><a href=\".\"><b>more</b></a></html>");
                } else {
                    closedPosition = this.entitySplitPane.getWidth();
                    Log.debug(50, "HORIZONAL_SPLIT, closedPosition=" + closedPosition);
                }
                this.entitySplitPane.setDividerLocation(closedPosition);
            }
        }
    }

    private class TabbedContainer
    extends Container {
        JSplitPane splitPane = null;
        MetaDisplayInterface metaDisplay = null;

        public TabbedContainer() {
            this.setLayout(new BorderLayout());
        }

        public JSplitPane getSplitPane() {
            return this.splitPane;
        }

        public void setSplitPane(JSplitPane pane) {
            this.splitPane = pane;
            this.add((Component)this.splitPane, "Center");
        }

        public MetaDisplayInterface getMetaDisplayInterface() {
            return this.metaDisplay;
        }

        public void setMetaDisplayInterface(MetaDisplayInterface display) {
            this.metaDisplay = display;
        }
    }
}

