/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import javax.swing.text.JTextComponent;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Element;

public class AssertTextFieldContainsTagHandler
extends AbstractTagHandler {
    public AssertTextFieldContainsTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String id = this.getString("id");
        Object o = ((IXMLTestCase)this.getTestCase()).getProperty(id);
        if (o == null) {
            System.out.println("Error: Unable to locate object id:" + id);
        } else if (o instanceof JTextComponent) {
            String expectedval = this.getString("value");
            JTextComponent jtf = (JTextComponent)o;
            String msg = "Component: " + id + " Expected: " + expectedval + " Retrieved: " + jtf.getText();
            boolean useRegExp = this.getBoolean("useRE");
            if (useRegExp) {
                RE regexp = null;
                try {
                    regexp = new RE(expectedval);
                }
                catch (RESyntaxException ex) {
                    throw new XMLException("Could not create regular expression:" + expectedval, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
                }
                Assert.assertTrue((String)msg, (boolean)regexp.match(jtf.getText()));
            } else {
                if (!jtf.getText().equals(expectedval)) {
                    System.out.println("Assertion failed: " + msg);
                }
                Assert.assertEquals((String)jtf.getText(), (String)expectedval);
            }
        } else {
            throw new XMLException("id does not reference a JTextComponent", null, this.getElement(), this.getTest().getPropertyCache());
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("value");
    }
}

