/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.keyboard;

import java.util.HashMap;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;

public abstract class AbstractKeyMapping
implements KeyMapping {
    private final HashMap m_mapChar = new HashMap();
    private final HashMap m_mapCode = new HashMap();

    public AbstractKeyMapping(Object[][] charMap) {
        for (int i = 0; i < charMap.length; ++i) {
            Object c = charMap[i][0];
            JFCKeyStroke[] codes = new JFCKeyStroke[charMap[i].length - 1];
            for (int j = 1; j < charMap[i].length; ++j) {
                codes[j - 1] = (JFCKeyStroke)charMap[i][j];
            }
            if (c instanceof Character) {
                this.m_mapChar.put(c, codes);
            }
            if (!(c instanceof Integer)) continue;
            this.m_mapCode.put(c, codes);
        }
    }

    public JFCKeyStroke[] getKeyStrokes(char c) {
        return this.getKeyStrokes(new Character(c), this.m_mapChar);
    }

    public JFCKeyStroke[] getKeyStrokes(int keyCode) {
        return this.getKeyStrokes(new Integer(keyCode), this.m_mapCode);
    }

    private JFCKeyStroke[] getKeyStrokes(Object key, HashMap map) {
        JFCKeyStroke[] codes = (JFCKeyStroke[])map.get(key);
        if (codes == null) {
            return new JFCKeyStroke[0];
        }
        JFCKeyStroke[] retCodes = new JFCKeyStroke[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            retCodes[i] = new JFCKeyStroke(codes[i]);
        }
        return retCodes;
    }
}

