/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.text.JTextComponent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.finder.ComponentFinder;
import org.w3c.dom.Element;

public class JSpinnerMouseEventData
extends AbstractMouseEventData {
    private static Class s_spinnerClass = null;
    private Component m_comp;
    private Component m_source;
    private int m_offset = -1;
    private int m_subComponent = -1;
    static /* synthetic */ Class class$javax$swing$JButton;

    public JSpinnerMouseEventData() {
        this.setValid(false);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent) {
        this(testCase, comp, subComponent, 1);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks) {
        this(testCase, comp, subComponent, numberOfClicks, 16);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, long sleepTime) {
        this(testCase, comp, subComponent, 1, sleepTime);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers) {
        this(testCase, comp, subComponent, numberOfClicks, modifiers, false);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, comp, subComponent, numberOfClicks, JSpinnerMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, long sleepTime) {
        this(testCase, comp, subComponent, numberOfClicks, 16, false, sleepTime);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers, boolean isPopupTrigger) {
        this(testCase, comp, subComponent, numberOfClicks, modifiers, isPopupTrigger, 300L);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, subComponent, numberOfClicks, JSpinnerMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, subComponent, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null, -1);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comp, subComponent, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null, -1);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comp, subComponent, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint, -1);
    }

    public JSpinnerMouseEventData(JFCTestCase testCase, Component comp, int subComponent, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint, int offset) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setSubComponent(subComponent);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setOffset(offset);
        this.setValid(true);
    }

    public final void setSource(Component comp) {
        this.m_source = comp;
    }

    public final Component getSource() {
        return this.m_source;
    }

    public final void setSubComponent(int subComponent) {
        this.m_subComponent = subComponent;
    }

    public final int getSubComponent() {
        return this.m_subComponent;
    }

    public void setComponent(Component comp) {
        this.m_comp = comp;
    }

    public Component getComponent() {
        return this.m_comp;
    }

    public final void setOffset(int offset) {
        this.m_offset = offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public boolean canConsume(AWTEvent ae) {
        return false;
    }

    public boolean consume(AWTEvent ae) {
        return false;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JSpinnerMouseEventData data = (JSpinnerMouseEventData)o;
        return data.getSource() == this.getSource() && data.getSubComponent() == this.getSubComponent() && data.getOffset() == this.getOffset();
    }

    public int hashCode() {
        return super.hashCode() + this.m_offset;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JSpinnerMouseEventData");
        if (this.getOffset() != -1) {
            e.setAttribute("sub", "editor");
            e.setAttribute("index", "" + this.getOffset());
        } else if (this.getSubComponent() == 1) {
            e.setAttribute("sub", "up");
        } else if (this.getSubComponent() == 2) {
            e.setAttribute("sub", "down");
        }
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource()) || s_spinnerClass == null) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.pauseAWT();
        }
        Component c = null;
        Rectangle bounds = null;
        ComponentFinder f = new ComponentFinder(class$javax$swing$JButton == null ? (class$javax$swing$JButton = JSpinnerMouseEventData.class$("javax.swing.JButton")) : class$javax$swing$JButton);
        switch (this.getSubComponent()) {
            case 2: {
                c = f.find((Container)this.getSource(), 1);
                bounds = c.getBounds();
                bounds.setLocation(c.getLocationOnScreen());
                this.setLocationOnScreen(this.calculatePoint(bounds));
                break;
            }
            case 1: {
                c = f.find((Container)this.getSource(), 0);
                bounds = c.getBounds();
                bounds.setLocation(c.getLocationOnScreen());
                this.setLocationOnScreen(this.calculatePoint(bounds));
                break;
            }
            case 3: {
                try {
                    c = (Component)s_spinnerClass.getMethod("getEditor", new Class[0]).invoke((Object)this.getSource(), new Object[0]);
                    Class<?> defEditor = Class.forName("javax.swing.JSpinner$DefaultEditor");
                    if (defEditor.isInstance(c)) {
                        c = (JTextComponent)defEditor.getMethod("getTextField", new Class[0]).invoke((Object)c, new Object[0]);
                    }
                    if (this.getPosition() == 14 && c instanceof JTextComponent) {
                        this.setPosition(3);
                        Point p = this.calculatePoint(((JTextComponent)c).modelToView(this.m_offset));
                        Point screen = c.getLocationOnScreen();
                        screen.translate(p.x, p.y);
                        this.setLocationOnScreen(screen);
                        break;
                    }
                    Point p = this.calculatePoint(c.getBounds());
                    Point screen = c.getLocationOnScreen();
                    screen.translate(p.x, p.y);
                    this.setLocationOnScreen(screen);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new RuntimeException("JSpinnerMouseEventData invalid sub component type");
            }
        }
        this.setComponent(c);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            s_spinnerClass = Class.forName("javax.swing.JSpinner");
        }
        catch (Exception e) {
            s_spinnerClass = null;
        }
    }
}

