/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.lens;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;
import multivalent.std.lens.Lens;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Magnify
extends Lens {
    public static final String MSG_MAGNIFY = "magnifyLens";
    public static final String ATTR_ZOOM = "zoom";
    public static final String ATTR_ZOOMS = "zooms";
    static int izoom_ = -1;
    int[] zooms_ = null;
    int zoom_;
    protected VRadiogroup rg_ = new VRadiogroup();
    private Point rel_ = new Point();

    @Override
    public boolean paintBefore(Context context, Node node) {
        super.paintBefore(context, node);
        Rectangle rectangle = this.getContentBounds();
        Graphics2D graphics2D = context.g;
        double d = (double)this.zoom_ / 100.0;
        graphics2D.translate((double)rectangle.x - (double)rectangle.x * d, (double)rectangle.y - (double)rectangle.y * d);
        graphics2D.scale(d, d);
        return false;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.zoom_ = izoom_ < 0 ? (izoom_ = Integers.parseInt(this.getAttr(ATTR_ZOOM), 200)) : Integers.parseInt(this.getAttr(ATTR_ZOOM), izoom_);
        String[] stringArray = this.getAttr(ATTR_ZOOMS, "50,125,150,200,300,400").split(",");
        this.zooms_ = new int[stringArray.length];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.zooms_[i] = Integer.parseInt(stringArray[i].trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.zooms_[i] = 100;
            }
        }
        this.win_.setTitle(new StringBuffer().append("Magnify ").append(this.zoom_).append("%").toString());
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/DOCPOPUP" == string && semanticEvent.getIn() == this.win_) {
            Browser browser = this.getBrowser();
            INode iNode = (INode)semanticEvent.getOut();
            this.rg_.clear();
            int n = this.zooms_.length;
            for (int i = 0; i < n; ++i) {
                VRadiobox vRadiobox = (VRadiobox)this.createUI("radiobox", new StringBuffer().append("Magnify ").append(this.zooms_[i]).append("%").toString(), new SemanticEvent(browser, MSG_MAGNIFY, new Integer(this.zooms_[i]), this, null), iNode, "VIEW", false);
                vRadiobox.setRadiogroup(this.rg_);
                vRadiobox.setState(this.zooms_[i] == this.zoom_);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        int n;
        Object object = semanticEvent.getArg();
        if (MSG_MAGNIFY == string && semanticEvent.getIn() == this && object instanceof Integer && (n = ((Integer)object).intValue()) != this.zoom_) {
            this.zoom_ = izoom_ = n;
            this.win_.setTitle(new StringBuffer().append("Magnify ").append(this.zoom_).append("%").toString());
            this.getBrowser().repaint();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

