/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamLZW
extends FilterInputStream {
    private static final boolean DEBUG = false;
    private static final int CLEAR = 256;
    private int eod_;
    private int tablestart_;
    private static final int C_MAGIC1 = 31;
    private static final int C_MAGIC2 = 157;
    private static final int C_BITMASK = 31;
    private static final int C_BLOCKMODE = 128;
    static final int MINBITS = 9;
    private int maxbits_;
    private int maxlen_;
    private byte[] nextByte_;
    private int[] prevEntry_;
    private int tablei_;
    private int tablelen_;
    private int codelen_ = 9;
    private int mask_ = 511;
    private int prevcode_ = -1;
    private int bits_ = 0;
    private int validcnt_ = 0;
    private boolean high_;
    int bitcnt_;
    private int early_;
    private byte[] phrase_;
    private int phrasei_;
    private boolean eof_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InputStreamLZW(InputStream inputStream, boolean bl) throws IOException {
        super(inputStream);
        this.eod_ = 257;
        this.tablestart_ = this.eod_ + 1;
        this.init(12, false, bl);
    }

    public InputStreamLZW(InputStream inputStream) throws IOException {
        super(inputStream);
        if (inputStream.read() != 31 || inputStream.read() != 157) {
            throw new IOException("bad magic number");
        }
        this.eod_ = -1;
        this.tablestart_ = 257;
        int n = inputStream.read();
        int n2 = n & 0x1F;
        if (12 > n2 || n2 > 16) {
            throw new IOException("invalid max bits: " + n2);
        }
        this.init(n2, true, false);
        if ((n & 0x80) == 0) {
            --this.tablei_;
        }
    }

    private void init(int n, boolean bl, boolean bl2) {
        this.maxbits_ = n;
        this.high_ = bl;
        this.early_ = bl2 ? 1 : 0;
        this.maxlen_ = 1 << n;
        this.nextByte_ = new byte[this.maxlen_ + 1];
        this.prevEntry_ = new int[this.nextByte_.length];
        this.phrase_ = new byte[this.maxlen_];
        this.phrasei_ = this.maxlen_;
        this.tablelen_ = 512 - this.early_;
        this.tablei_ = this.tablestart_;
        for (int i = 0; i < 256; ++i) {
            this.nextByte_[i] = (byte)i;
            this.prevEntry_[i] = -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (this.eof_) {
            return -1;
        }
        n2 = Math.min(n2, byArray.length - n);
        byte[] byArray2 = this.phrase_;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (this.phrasei_ < this.maxlen_) {
                int n4 = this.phrasei_;
                int n5 = Math.min(this.maxlen_ - n4, n3 - i);
                int n6 = i + n5;
                for (int j = i; j < n6; ++j) {
                    byArray[j] = byArray2[n4++];
                }
                i += n5 - 1;
                this.phrasei_ += n5;
                continue;
            }
            int n7 = this.read();
            if (n7 != -1) {
                byArray[i] = (byte)n7;
                continue;
            }
            return i - n;
        }
        return n2;
    }

    public int read() throws IOException {
        int n;
        if (this.phrasei_ < this.maxlen_) {
            n = this.phrase_[this.phrasei_++] & 0xFF;
        } else if (this.eof_) {
            n = -1;
        } else {
            int n2;
            if (!$assertionsDisabled && this.validcnt_ >= this.codelen_) {
                throw new AssertionError();
            }
            int n3 = this.in.read();
            if (this.high_) {
                this.bits_ = n3 << this.validcnt_ | this.bits_;
                this.validcnt_ += 8;
                if (this.validcnt_ < this.codelen_) {
                    this.bits_ = this.in.read() << this.validcnt_ | this.bits_;
                    this.validcnt_ += 8;
                }
                n2 = this.bits_ & this.mask_;
                this.validcnt_ -= this.codelen_;
                this.bitcnt_ += this.codelen_;
                this.bits_ = this.bits_ >> this.codelen_ & (1 << this.validcnt_) - 1;
            } else {
                this.bits_ = this.bits_ << 8 | n3;
                this.validcnt_ += 8;
                if (this.validcnt_ < this.codelen_) {
                    this.bits_ = this.bits_ << 8 | this.in.read();
                    this.validcnt_ += 8;
                }
                n2 = this.bits_ >> this.validcnt_ - this.codelen_ & this.mask_;
                this.validcnt_ -= this.codelen_;
            }
            if (!$assertionsDisabled && this.validcnt_ >= 9) {
                throw new AssertionError(this.validcnt_);
            }
            if (n2 == 256) {
                this.tablei_ = this.tablestart_;
                this.tablelen_ = 512 - this.early_;
                if (this.high_) {
                    int n4 = this.codelen_ * 8;
                    int n5 = this.bitcnt_ % n4;
                    if (n5 > 0) {
                        int n6 = (n4 - n5) / 8;
                        for (int i = 0; i < n6; ++i) {
                            this.in.read();
                        }
                    }
                    this.bitcnt_ = 0;
                    --this.tablei_;
                } else {
                    this.prevcode_ = -1;
                }
                this.codelen_ = 9;
                this.mask_ = (1 << this.codelen_) - 1;
                n = this.read();
            } else if (n2 == this.eod_ || n3 == -1) {
                n = -1;
                this.eof_ = true;
            } else {
                this.prevEntry_[this.tablei_] = this.prevcode_;
                if (n2 < 256) {
                    this.nextByte_[this.tablei_] = (byte)n2;
                    n = n2;
                } else if (n2 > this.tablei_) {
                    n = -1;
                    this.eof_ = true;
                } else {
                    int n7 = n2;
                    while (n7 != -1) {
                        this.phrase_[--this.phrasei_] = this.nextByte_[n7];
                        n7 = this.prevEntry_[n7];
                    }
                    n = this.nextByte_[this.tablei_] = this.phrase_[this.phrasei_++];
                    if (n2 == this.tablei_) {
                        this.phrase_[this.maxlen_ - 1] = (byte)n;
                    }
                    n &= 0xFF;
                }
                if (this.prevcode_ != -1 && this.tablei_ < this.tablelen_) {
                    ++this.tablei_;
                    if (this.tablei_ == this.tablelen_ && this.codelen_ < this.maxbits_) {
                        ++this.codelen_;
                        this.mask_ = (1 << this.codelen_) - 1;
                        this.tablelen_ = (1 << this.codelen_) - this.early_;
                    }
                }
                this.prevcode_ = n2;
            }
        }
        if (!($assertionsDisabled || -1 <= n && n <= 255)) {
            throw new AssertionError();
        }
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.eof_ = true;
        super.close();
    }

    static {
        $assertionsDisabled = !InputStreamLZW.class.desiredAssertionStatus();
    }
}

