/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swing.SwingComponentWrapper;
import net.miginfocom.swing.SwingContainerWrapper;

public final class MigLayout
implements LayoutManager2,
Externalizable {
    private final Map<Component, Object> scrConstrMap = new IdentityHashMap<Component, Object>(8);
    private Object layoutConstraints = "";
    private Object colConstraints = "";
    private Object rowConstraints = "";
    private transient ContainerWrapper cacheParentW = null;
    private final transient Map<ComponentWrapper, CC> ccMap = new HashMap<ComponentWrapper, CC>(8);
    private transient Timer debugTimer = null;
    private transient LC lc = null;
    private transient AC colSpecs = null;
    private transient AC rowSpecs = null;
    private transient Grid grid = null;
    private transient int lastModCount = PlatformDefaults.getModCount();
    private transient int lastHash = -1;
    private transient Dimension lastInvalidSize = null;
    private transient ArrayList<LayoutCallback> callbackList = null;
    private static final /* synthetic */ Class class$net$miginfocom$swing$MigLayout;

    public MigLayout() {
        this("", "", "");
    }

    public MigLayout(String string) {
        this(string, "", "");
    }

    public MigLayout(String string, String string2) {
        this(string, string2, "");
    }

    public MigLayout(String string, String string2, String string3) {
        this.setLayoutConstraints(string);
        this.setColumnConstraints(string2);
        this.setRowConstraints(string3);
    }

    public MigLayout(LC lC) {
        this(lC, null, null);
    }

    public MigLayout(LC lC, AC aC) {
        this(lC, aC, null);
    }

    public MigLayout(LC lC, AC aC, AC aC2) {
        this.setLayoutConstraints(lC);
        this.setColumnConstraints(aC);
        this.setRowConstraints(aC2);
    }

    public Object getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(Object object) {
        if (object == null || object instanceof String) {
            object = ConstraintParser.prepare((String)object);
            this.lc = ConstraintParser.parseLayoutConstraint((String)object);
        } else if (object instanceof LC) {
            this.lc = (LC)object;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + object.getClass().toString());
        }
        this.layoutConstraints = object;
        this.grid = null;
    }

    public Object getColumnConstraints() {
        return this.colConstraints;
    }

    public void setColumnConstraints(Object object) {
        if (object == null || object instanceof String) {
            object = ConstraintParser.prepare((String)object);
            this.colSpecs = ConstraintParser.parseColumnConstraints((String)object);
        } else if (object instanceof AC) {
            this.colSpecs = (AC)object;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + object.getClass().toString());
        }
        this.colConstraints = object;
        this.grid = null;
    }

    public Object getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(Object object) {
        if (object == null || object instanceof String) {
            object = ConstraintParser.prepare((String)object);
            this.rowSpecs = ConstraintParser.parseRowConstraints((String)object);
        } else if (object instanceof AC) {
            this.rowSpecs = (AC)object;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + object.getClass().toString());
        }
        this.rowConstraints = object;
        this.grid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentConstraints(Component component) {
        Object object = component.getParent().getTreeLock();
        synchronized (object) {
            return this.scrConstrMap.get(component);
        }
    }

    public void setComponentConstraints(Component component, Object object) {
        this.setComponentConstraintsImpl(component, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setComponentConstraintsImpl(Component component, Object object, boolean bl) {
        Container container = component.getParent();
        Object object2 = container.getTreeLock();
        synchronized (object2) {
            if (!bl && !this.scrConstrMap.containsKey(component)) {
                throw new IllegalArgumentException("Component must already be added to parent!");
            }
            SwingComponentWrapper swingComponentWrapper = new SwingComponentWrapper(component);
            if (object == null || object instanceof String) {
                String string = ConstraintParser.prepare((String)object);
                this.scrConstrMap.put(component, object);
                this.ccMap.put(swingComponentWrapper, ConstraintParser.parseComponentConstraint(string));
            } else if (object instanceof CC) {
                this.scrConstrMap.put(component, object);
                this.ccMap.put(swingComponentWrapper, (CC)object);
            } else {
                throw new IllegalArgumentException("Constraint must be String or ComponentConstraint: " + object.getClass().toString());
            }
            this.grid = null;
        }
    }

    public boolean isManagingComponent(Component component) {
        return this.scrConstrMap.containsKey(component);
    }

    public void addLayoutCallback(LayoutCallback layoutCallback) {
        if (layoutCallback == null) {
            throw new NullPointerException();
        }
        if (this.callbackList == null) {
            this.callbackList = new ArrayList(1);
        }
        this.callbackList.add(layoutCallback);
    }

    public void removeLayoutCallback(LayoutCallback layoutCallback) {
        if (this.callbackList != null) {
            this.callbackList.remove(layoutCallback);
        }
    }

    private synchronized void setDebug(ComponentWrapper componentWrapper, boolean bl) {
        if (bl && (this.debugTimer == null || this.debugTimer.getDelay() != this.lc.getDebugMillis())) {
            if (this.debugTimer != null) {
                this.debugTimer.stop();
            }
            final Component component = (Component)componentWrapper.getParent().getComponent();
            this.debugTimer = new Timer(this.lc.getDebugMillis(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MigLayout.this.grid != null) {
                        MigLayout.this.grid.paintDebug();
                    }
                }
            });
            if (component != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Container container = component.getParent();
                        if (container != null) {
                            if (container instanceof JComponent) {
                                ((JComponent)container).revalidate();
                            } else {
                                component.invalidate();
                                container.validate();
                            }
                        }
                    }
                });
            }
            this.debugTimer.setInitialDelay(100);
            this.debugTimer.start();
        } else if (!bl && this.debugTimer != null) {
            this.debugTimer.stop();
            this.debugTimer = null;
        }
    }

    private boolean getDebug() {
        return this.debugTimer != null;
    }

    private final void checkCache(Container container) {
        if (container == null) {
            return;
        }
        ContainerWrapper containerWrapper = this.checkParent(container);
        int n = PlatformDefaults.getModCount();
        if (this.lastModCount != n) {
            this.grid = null;
            this.lastModCount = n;
        }
        int n2 = 0;
        Object object = this.ccMap.keySet().iterator();
        while (object.hasNext()) {
            n2 += object.next().getLayoutHashCode();
        }
        if (n2 != this.lastHash) {
            this.grid = null;
            this.lastHash = n2;
        }
        if (!container.isValid()) {
            object = container.getSize();
            if (this.lastInvalidSize == null || !this.lastInvalidSize.equals(object)) {
                this.grid = null;
                this.lastInvalidSize = object;
            }
        }
        this.setDebug(containerWrapper, this.lc.getDebugMillis() > 0);
        if (this.grid == null) {
            this.grid = new Grid(containerWrapper, this.lc, this.rowSpecs, this.colSpecs, this.ccMap, this.callbackList);
        }
    }

    private final ContainerWrapper checkParent(Container container) {
        if (container == null) {
            return null;
        }
        if (this.cacheParentW == null || this.cacheParentW.getComponent() != container) {
            this.cacheParentW = new SwingContainerWrapper(container);
        }
        return this.cacheParentW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkCache(container);
            Insets insets = container.getInsets();
            int[] nArray = new int[]{insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom};
            this.grid.layout(nArray, this.lc.getAlignX(), this.lc.getAlignY(), this.getDebug(), false);
            this.lastInvalidSize = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.getSizeImpl(container, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.getSizeImpl(container, 1);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private Dimension getSizeImpl(Container container, int n) {
        this.checkCache(container);
        Insets insets = container.getInsets();
        int n2 = LayoutUtil.getSizeSafe(this.grid != null ? this.grid.getWidth() : null, n) + insets.left + insets.right;
        int n3 = LayoutUtil.getSizeSafe(this.grid != null ? this.grid.getHeight() : null, n) + insets.top + insets.bottom;
        return new Dimension(n2, n3);
    }

    public float getLayoutAlignmentX(Container container) {
        return this.lc != null && this.lc.getAlignX() != null ? (float)this.lc.getAlignX().getPixels(1.0f, this.checkParent(container), null) : 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return this.lc != null && this.lc.getAlignY() != null ? (float)this.lc.getAlignY().getPixels(1.0f, this.checkParent(container), null) : 0.0f;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getParent().getTreeLock();
        synchronized (object2) {
            this.setComponentConstraintsImpl(component, object, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getParent().getTreeLock();
        synchronized (object) {
            this.scrConstrMap.remove(component);
            this.ccMap.remove(new SwingComponentWrapper(component));
        }
    }

    public void invalidateLayout(Container container) {
        if (this.lc.isNoCache()) {
            this.grid = null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return LayoutUtil.getSerializedObject(this);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LayoutUtil.setSerializedObject(this, LayoutUtil.readAsXML(objectInput));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.getClass() == (class$net$miginfocom$swing$MigLayout == null ? (class$net$miginfocom$swing$MigLayout = MigLayout.class$("net.miginfocom.swing.MigLayout")) : class$net$miginfocom$swing$MigLayout)) {
            LayoutUtil.writeAsXML(objectOutput, this);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

