/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class UISettings {
    private static final Dimension scrDim = Toolkit.getDefaultToolkit().getScreenSize();
    public static final int CLIENT_SCREEN_WIDTH = (int)scrDim.getWidth();
    public static final int CLIENT_SCREEN_HEIGHT = (int)scrDim.getHeight();
    public static final int TASKBAR_HEIGHT = 100;
    public static final double DEFAULT_WINDOW_WIDTH = UISettings.getWindowWidth();
    public static final double DEFAULT_WINDOW_HEIGHT = UISettings.getWindowHeight();
    public static final int FOCUS_BORDER_WIDTH = 4;
    private static final int TITLEBAR_HEIGHT = 27;
    public static final int TITLEBAR_TOP_PADDING = 0;
    public static final int TITLEBAR_SIDES_PADDING = 0;
    public static final int TITLEBAR_BOTTOM_PADDING = 2;
    public static final int PATHBAR_TOP_PADDING = 2;
    public static final int PATHBAR_SIDES_PADDING = 0;
    public static final int PATHBAR_BOTTOM_PADDING = 2;
    public static final int WIZARD_PADDING = 5;
    public static final Insets METAVIEW_BUTTON_INSETS = new Insets(2, 5, 2, 5);
    private static final int DUMMY_WIDTH = 5000;
    public static final Dimension TITLEBAR_DIMS = new Dimension(5000, 27);
    public static final Dimension HEADER_BOTTOMLINE_DIMS = new Dimension(5000, 2);
    public static final int TITLEBAR_COMPONENT_HEIGHT = 25;
    public static final int TITLE_CITATION_HEIGHT = 50;
    public static final Dimension TITLE_CITATION_DIMS = new Dimension(5000, 50);
    public static final int TITLE_LOCATION_HEIGHT = 50;
    public static final int TITLE_LOCATION_WIDTH = 51;
    public static final Dimension TITLE_LOCATION_DIMS = new Dimension(51, 50);
    public static final int VERT_SPLIT_INIT_LOCATION = 52;
    public static final int MAX_WINDOW_WIDTH = 1024;
    public static final int MAX_WINDOW_HEIGHT = 768;
    public static final int WINDOW_CASCADE_X_OFFSET = 25;
    public static final int WINDOW_CASCADE_Y_OFFSET = 25;
    public static final int INIT_SCRN_LEFT_PANELS_PADDING = 15;
    public static final Dimension INIT_SCRN_LEFT_PANELS_LABELDIMS = new Dimension(120, 20);
    public static final Dimension INIT_SCRN_LEFT_PANELS_PICKLISTDIMS = new Dimension(130, 22);
    public static final Dimension INIT_SCR_LINKBUTTON_DIMS = new Dimension(280, 20);
    public static final Dimension INIT_SCR_LOGIN_BUTTON_DIMS = new Dimension(50, 25);
    public static final int INIT_SCRN_LEFT_PANELS_WIDTH = 340;
    public static final int INIT_SCRN_PROFILE_PANEL_HEIGHT = 110;
    public static final int INIT_SCRN_LOGIN_PANEL_HEIGHT = 120;
    public static final int INIT_SCRN_DATA_PANEL_HEIGHT = 115;
    public static final Dimension INIT_SCRN_LEFT_PANELS_TITLE_DIMS = new Dimension(340, 18);
    public static final int WIZARD_X_COORD = 100;
    public static final int WIZARD_Y_COORD = 100;
    public static final int WIZARD_WIDTH = 800;
    public static final int WIZARD_HEIGHT = 600;
    public static final int DIALOG_SMALLER_THAN_WIZARD_BY = 30;
    public static final int POPUPDIALOG_WIDTH = 770;
    public static final int POPUPDIALOG_HEIGHT = 570;
    public static final int POPUPDIALOG_FOR_ATTR_HEIGHT = 600;
    public static final Font SUBPANEL_TITLE_FONT = new Font("Dialog", 1, 12);
    public static final Font BUTTON_FONT = new Font("Sans-Serif", 1, 11);
    public static final Font TITLE_CITATION_FONT = new Font("Dialog", 0, 12);
    public static final Font TITLE_CITATION_FONT_BOLD = new Font("Dialog", 1, 12);
    public static final Font TITLE_LOCATION_FONT = new Font("Dialog", 0, 9);
    public static final Font POPUPDIALOG_BUTTON_FONT = new Font("Sans-Serif", 0, 11);
    public static final String HYPERLINK_FONT_HTML_OPENTAGS = "<html><p style=\"color: #0000d2; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;";
    public static final String HYPERLINK_FONT_HTML_CLOSETAGS = "</p></html>";
    public static final String HYPERLINK_FONT_OVER_HTML_OPENTAGS = "<html><a href=\"#\" style=\"color: #ee5500; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;";
    public static final String HYPERLINK_FONT_OVER_HTML_CLOSETAGS = "</a></html>";
    public static final String INIT_SCR_PANEL_TITLE_HILITE_FONT_OPEN = "<font color=\"#d2ffad\"><b>";
    public static final String INIT_SCR_PANEL_TITLE_HILITE_FONT_CLOSE = "</b></font>";
    public static final String INIT_SCR_PANEL_LITE_FONT_OPEN = "<html><p style=\"color: #666666; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 8px; align: left;\">";
    public static final String INIT_SCR_PANEL_LITE_FONT_CLOSE = "</p></html>";
    public static final Color TITLE_TEXT_COLOR = Color.white;
    public static final Color BACKBUTTON_TEXT_COLOR;
    public static final Color CLOSEBUTTON_TEXT_COLOR;
    public static final Color EDITBUTTON_TEXT_COLOR;
    public static final Color BUTTON_DISABLED_TEXT_COLOR;
    public static final Color POPUPDIALOG_BUTTON_TEXT_COLOR;
    public static final Color ALERT_TEXT_COLOR;
    public static final Color TITLEBAR_COLOR;
    public static final Color BACKGROUND_COLOR;
    public static final Color BOTTOMLINE_COLOR;
    public static final Color BACKBUTTON_COLOR;
    public static final Color CLOSEBUTTON_COLOR;
    public static final Color EDITBUTTON_COLOR;
    public static final Color CUSTOM_GRAY;
    public static final Color FOCUSED_BORDER_COLOR;
    public static final Color UNFOCUSED_BORDER_COLOR;
    public static final Color NONEDITABLE_BACKGROUND_COLOR;
    public static final Color INIT_SCRN_LEFT_PANELS_BG_COLOR;
    public static final Color INIT_SCRN_LEFT_PANELS_TITLE_BG_COLOR;
    public static final Color INIT_SCRN_MAIN_BG_COLOR;
    public static final Image FRAME_AND_TASKBAR_ICON;
    public static final Image INIT_SCR_BACKGROUND;
    public static final Icon NEW_DATAPACKAGE_ICON;
    public static final Icon NEW_DATAPACKAGE_ICON_ROLLOVER;
    public static final Icon OPEN_DATAPACKAGE_ICON;
    public static final Icon OPEN_DATAPACKAGE_ICON_ROLLOVER;
    public static final Icon SEARCH_ICON;
    public static final Icon SEARCH_ICON_ROLLOVER;
    public static final Icon REFRESH_ICON;
    public static final Icon SAVE_ICON;
    public static final Icon DUPLICATE_ICON;
    public static final Icon SAVE_QUERY_ICON;
    public static final Icon NEW_PROFILE_ICON;
    public static final Icon NEW_PROFILE_ICON_ROLLOVER;
    public static final Icon LOGOUT_ICON;
    public static final Icon LOGOUT_ICON_ROLLOVER;
    public static final String INIT_SCRN_PANELS_PROFILE_TITLE_TEXT_OPEN = "<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Current profile:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String INIT_SCRN_PANELS_LOGIN_TITLE_TEXT_OPEN = "<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Network Status:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String INIT_SCRN_PANELS_DATA_TITLE_TEXT_OPEN = "<html><p style=\"color: #ffffff; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;Work with your data...";
    public static final String INIT_SCRN_PANELS_TITLE_CLOSE = "</p></html>";
    public static final String NEW_DATAPACKAGE_LINK_TEXT = "Create a <b>new</b> data package...";
    public static final String OPEN_DATAPACKAGE_LINK_TEXT = "Open an <b>existing</b> data package...";
    public static final String SEARCH_LINK_TEXT = "<b>Search</b> for an existing data package...";
    public static final String NEW_PROFILE_LINK_TEXT = "Create a new profile...";
    public static final String LOGOUT_LINK_TEXT = "<b>Logout</b> from network...";
    public static final String CHANGE_PROFILE_LABEL_TEXT = "<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;<b>Change profile:</b></p></html>";
    public static final String PASSWORD_LABEL_TEXT = "<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;Password:</p></html>";
    public static final String INIT_SCR_LOGIN_MESSAGE = "If you do not choose to login, you will be able to access only \"public\" network files as a Guest User";
    public static final String INIT_SCR_LOGGED_IN_MESSAGE = "You are logged into the network, and may work with all files for which you have access privileges ";
    public static final String INIT_SCR_LOGIN_BUTTON_TEXT = "<html><p style=\"color: #000000; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">login</p></html>";
    public static final String INIT_SCR_LOGIN_HEADER = "<html><p style=\"color: #000000; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;font-weight: bold;\">Login to network using current profile:</p></html>";
    public static final String INIT_SCR_LOGGED_IN_STATUS = "Logged In";
    public static final String INIT_SCR_LOGGEDOUT_STATUS = "NOT Logged In";
    public static final String OK_BUTTON_TEXT = "OK";
    public static final String CANCEL_BUTTON_TEXT = "Cancel";
    private static long previousTimeStamp;
    private static Object cpLocator;

    public static String getUniqueID() {
        long timeStamp = 0L;
        while ((timeStamp = System.currentTimeMillis()) == previousTimeStamp) {
        }
        previousTimeStamp = timeStamp;
        String id = String.valueOf(timeStamp);
        return id;
    }

    private static double getWindowWidth() {
        if (CLIENT_SCREEN_WIDTH >= 1024) {
            return 1024.0;
        }
        return CLIENT_SCREEN_WIDTH;
    }

    private static double getWindowHeight() {
        if (CLIENT_SCREEN_HEIGHT >= 768) {
            return 668.0;
        }
        return CLIENT_SCREEN_HEIGHT - 100;
    }

    private static Color verifyButtonTextColor(Color proposedColor) {
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") < 0) {
            return proposedColor;
        }
        float[] hsb = new float[3];
        Color.RGBtoHSB(proposedColor.getRed(), proposedColor.getGreen(), proposedColor.getBlue(), hsb);
        if (hsb[1] <= 0.5f) {
            hsb[1] = 1.0f;
        }
        if (hsb[2] > 0.5f) {
            hsb[2] = 0.5f;
        }
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    private static Image getAsImage(String path) {
        if (cpLocator == null) {
            cpLocator = new Object();
        }
        return new ImageIcon(cpLocator.getClass().getResource(path)).getImage();
    }

    private static Icon getAsImageIcon(String path) {
        return new ImageIcon(UISettings.getAsImage(path));
    }

    private UISettings() {
    }

    static {
        CLOSEBUTTON_TEXT_COLOR = BACKBUTTON_TEXT_COLOR = UISettings.verifyButtonTextColor(new Color(178, 238, 255));
        EDITBUTTON_TEXT_COLOR = UISettings.verifyButtonTextColor(new Color(153, 255, 153));
        BUTTON_DISABLED_TEXT_COLOR = new Color(204, 204, 204);
        POPUPDIALOG_BUTTON_TEXT_COLOR = new Color(51, 51, 51);
        ALERT_TEXT_COLOR = Color.red;
        TITLEBAR_COLOR = new Color(117, 117, 117);
        BACKGROUND_COLOR = Color.lightGray;
        BOTTOMLINE_COLOR = Color.darkGray;
        BACKBUTTON_COLOR = TITLEBAR_COLOR;
        CLOSEBUTTON_COLOR = TITLEBAR_COLOR;
        EDITBUTTON_COLOR = TITLEBAR_COLOR;
        CUSTOM_GRAY = new Color(180, 180, 180);
        FOCUSED_BORDER_COLOR = new Color(115, 147, 196);
        UNFOCUSED_BORDER_COLOR = Color.gray;
        NONEDITABLE_BACKGROUND_COLOR = new Color(237, 237, 237);
        INIT_SCRN_LEFT_PANELS_BG_COLOR = Color.white;
        INIT_SCRN_LEFT_PANELS_TITLE_BG_COLOR = new Color(11, 85, 112);
        INIT_SCRN_MAIN_BG_COLOR = new Color(0, 153, 203);
        FRAME_AND_TASKBAR_ICON = UISettings.getAsImage("/edu/ucsb/nceas/morpho/framework/Btfly16x16.gif");
        INIT_SCR_BACKGROUND = UISettings.getAsImage("/edu/ucsb/nceas/morpho/framework/InitScreenBG.jpg");
        NEW_DATAPACKAGE_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/New16.gif");
        NEW_DATAPACKAGE_ICON_ROLLOVER = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/New16.gif");
        OPEN_DATAPACKAGE_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Open16.gif");
        OPEN_DATAPACKAGE_ICON_ROLLOVER = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Open16.gif");
        SEARCH_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Search16.gif");
        SEARCH_ICON_ROLLOVER = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Search16.gif");
        REFRESH_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Refresh16.gif");
        SAVE_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Save16.gif");
        DUPLICATE_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/Duplicate16.gif");
        SAVE_QUERY_ICON = UISettings.getAsImageIcon("/toolbarButtonGraphics/general/SaveAs16.gif");
        NEW_PROFILE_ICON = UISettings.getAsImageIcon("/edu/ucsb/nceas/morpho/framework/profile.gif");
        NEW_PROFILE_ICON_ROLLOVER = UISettings.getAsImageIcon("/edu/ucsb/nceas/morpho/framework/profile_OVER.gif");
        LOGOUT_ICON = UISettings.getAsImageIcon("/edu/ucsb/nceas/morpho/framework/login_no.gif");
        LOGOUT_ICON_ROLLOVER = UISettings.getAsImageIcon("/edu/ucsb/nceas/morpho/framework/login_no_OVER.gif");
        cpLocator = null;
    }
}

