/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressBarThread
extends Thread {
    private JDialog parentDialog = null;
    private JDialog dialog = null;
    private JProgressBar progressBar = null;
    private Timer timer = null;
    private boolean increaseValue = true;
    private JButton cancelButton;
    private int progressUpdateTime = 30;
    private int maximumValue = 100;
    private String pBarString = "";
    private int progressUpdateValue = 2;
    private Action customCancelAction;

    public ProgressBarThread() {
        this.parentDialog = null;
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(this.maximumValue);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.pBarString);
    }

    public ProgressBarThread(JDialog parentDialog) {
        this.parentDialog = parentDialog;
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(this.maximumValue);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.pBarString);
    }

    public void run() {
        this.dialog = this.parentDialog != null ? new JDialog(this.parentDialog, "Generating Access Tree", true) : new JDialog((Frame)null, "Generating Access Tree", true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProgressBarThread.this.customCancelAction != null) {
                    ProgressBarThread.this.customCancelAction.actionPerformed(null);
                }
                ProgressBarThread.this.timer.stop();
                ProgressBarThread.this.dialog.dispose();
            }
        };
        this.cancelButton = WidgetFactory.makeJButton("Cancel", actionListener);
        JPanel cancelButtonPanel = new JPanel();
        cancelButtonPanel.add(this.cancelButton);
        Container dialogContentPane = this.dialog.getContentPane();
        dialogContentPane.add((Component)this.progressBar, "Center");
        dialogContentPane.add((Component)cancelButtonPanel, "South");
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int value = ProgressBarThread.this.progressBar.getValue();
                if (value == ProgressBarThread.this.maximumValue) {
                    ProgressBarThread.this.increaseValue = false;
                }
                if (value == 0) {
                    ProgressBarThread.this.increaseValue = true;
                }
                value = ProgressBarThread.this.increaseValue ? (value += ProgressBarThread.this.progressUpdateValue) : (value -= ProgressBarThread.this.progressUpdateValue);
                ProgressBarThread.this.progressBar.setValue(value);
            }
        };
        this.timer = new Timer(this.progressUpdateTime, taskPerformer);
        this.timer.setRepeats(true);
        this.timer.start();
        this.dialog.setLocationRelativeTo(this.parentDialog);
        this.dialog.pack();
        this.dialog.show();
    }

    public void exitProgressBarThread() {
        this.timer.stop();
        this.dialog.dispose();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public int getProgressUpdateTime() {
        return this.progressUpdateTime;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public String getProgressBarString() {
        return this.progressBar.getString();
    }

    public int getProgressUpdateValue() {
        return this.progressUpdateValue;
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    public void setProgressUpdateTime(int progressUpdateTime) {
        this.progressUpdateTime = progressUpdateTime;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    public void setProgressBarString(String value) {
        this.progressBar.setString(value);
    }

    public void setProgressUpdateValue(int progressUpdateValue) {
        this.progressUpdateValue = progressUpdateValue;
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public void setCustomCancelAction(Action a) {
        this.customCancelAction = a;
    }
}

