/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.Log;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectCache {
    private Hashtable object_collection = new Hashtable();

    public void putObject(String docid, Object obj) {
        if (docid != null) {
            if (obj != null) {
                this.object_collection.put(docid, new WeakReference<Object>(obj));
            } else {
                Log.debug(20, "obj in ObjectCache.putObject is null!");
            }
        } else {
            Log.debug(20, "docid in ObjectCache.putObject is null!");
        }
    }

    public boolean isInObjectCollection(String docid) {
        boolean res = false;
        if (this.object_collection.containsKey(docid)) {
            WeakReference wr = (WeakReference)this.object_collection.get(docid);
            if (wr.get() != null) {
                res = true;
            } else {
                this.object_collection.remove(docid);
            }
        }
        return res;
    }

    public Object getObject(String docid) {
        Object res = null;
        if (this.isInObjectCollection(docid)) {
            WeakReference wr = (WeakReference)this.object_collection.get(docid);
            res = wr.get();
        } else {
            this.addNewObjectToCache(docid);
        }
        return res;
    }

    public int getSize() {
        this.cleanup();
        return this.object_collection.size();
    }

    public Enumeration getKeys() {
        this.cleanup();
        return this.object_collection.keys();
    }

    protected void addNewObjectToCache(String docid) {
    }

    private void cleanup() {
        Vector storageVec = new Vector();
        Enumeration enumeration = this.object_collection.keys();
        while (enumeration.hasMoreElements()) {
            storageVec.addElement(enumeration.nextElement());
        }
        for (int i = 0; i < storageVec.size(); ++i) {
            String docid = (String)storageVec.elementAt(i);
            if (!this.isInObjectCollection(docid)) continue;
        }
    }
}

