/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.plugins.metadisplay.HistoryItem;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;

public class History {
    private Stack historyStack = new Stack();

    public History() {
    }

    public History(HistoryItem item) {
        this();
        this.add(item);
    }

    public void add(HistoryItem item) {
        if (item != null) {
            this.historyStack.push(item);
        }
    }

    public void deletePrevious() {
        this.getPrevious();
    }

    public HistoryItem getPrevious() {
        if (this.historyStack.empty()) {
            return null;
        }
        return (HistoryItem)this.historyStack.pop();
    }

    public String previewPreviousID() {
        if (this.historyStack.empty()) {
            return null;
        }
        return ((HistoryItem)this.historyStack.peek()).identifier;
    }

    public String toString() {
        if (this.historyStack.empty()) {
            return "\n- - - History is Empty - - -\n";
        }
        Stack<HistoryItem> tempStack = new Stack<HistoryItem>();
        HistoryItem nextItem = null;
        StringBuffer buff = new StringBuffer("\n- - - History - - -\n");
        while (this.previewPreviousID() != null) {
            nextItem = (HistoryItem)this.historyStack.pop();
            if (nextItem == null) continue;
            tempStack.push(nextItem);
            buff.append("* ID: ");
            buff.append(nextItem.identifier);
            buff.append("\n  Transformer Parameters: \n");
            if (nextItem.transformProperties == null) continue;
            Iterator<Object> keys = nextItem.transformProperties.keySet().iterator();
            Object nextKey = null;
            while (keys.hasNext()) {
                nextKey = keys.next();
                buff.append("  -> ");
                buff.append(String.valueOf(nextKey));
                buff.append(" = ");
                buff.append(String.valueOf(nextItem.transformProperties.get(nextKey)));
                buff.append("\n");
            }
        }
        buff.append("- - End History - -\n");
        while (!tempStack.empty()) {
            this.historyStack.push(tempStack.pop());
        }
        return buff.toString();
    }

    public HistoryItem getNewHistoryItemInstance(String id, Properties params) {
        return new HistoryItem(id, params);
    }
}

