/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.plugins.metadisplay.BackCommand;
import edu.ucsb.nceas.morpho.plugins.metadisplay.CloseCommand;
import edu.ucsb.nceas.morpho.plugins.metadisplay.EditCommand;
import edu.ucsb.nceas.morpho.plugins.metadisplay.MetaDisplay;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalButtonUI;

public class HeaderPanel
extends JPanel {
    private static final String BACK_BUTTON_TEXT = "< back";
    private static final String EDIT_BUTTON_TEXT = "edit";
    private static final String CLOSE_BUTTON_TEXT = "hide X";
    private static final String TITLEBAR_INIT_TEXT = "Documentation";
    private static final String PATH_INIT_TEXT = "";
    private static final String PATH_SEPARATOR = ">>";
    private eJButton backButton;
    private eJButton closeButton;
    private final MetaDisplay controller;
    private JPanel titleBar;
    private JLabel titleTextLabel;

    public HeaderPanel(MetaDisplay controller) {
        this.controller = controller;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(true);
        this.setBackground(UISettings.BACKGROUND_COLOR);
        this.addTitleBar();
        this.addPathBar();
        this.addBottomLine();
    }

    private void addTitleBar() {
        this.titleBar = new JPanel();
        this.titleBar.setLayout(new BorderLayout(0, 0));
        this.titleBar.setPreferredSize(UISettings.TITLEBAR_DIMS);
        this.titleBar.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.setTitleBarColor(UISettings.TITLEBAR_COLOR);
        this.titleBar.setOpaque(true);
        this.add((Component)this.titleBar, "North");
        GUIAction backAction = new GUIAction(BACK_BUTTON_TEXT, null, new BackCommand(this.controller));
        this.backButton = new eJButton(backAction);
        this.backButton.setBackground(UISettings.BACKBUTTON_COLOR);
        this.backButton.setForeground(UISettings.BACKBUTTON_TEXT_COLOR);
        this.backButton.setFocusPainted(false);
        this.backButton.setFont(UISettings.BUTTON_FONT);
        this.titleBar.add((Component)this.backButton, "West");
        this.titleTextLabel = new JLabel(TITLEBAR_INIT_TEXT);
        this.titleTextLabel.setForeground(UISettings.TITLE_TEXT_COLOR);
        this.titleTextLabel.setFont(UISettings.SUBPANEL_TITLE_FONT);
        this.titleTextLabel.setHorizontalAlignment(0);
        this.titleBar.add((Component)this.titleTextLabel, "Center");
        GUIAction closeAction = new GUIAction(CLOSE_BUTTON_TEXT, null, new CloseCommand(this.controller));
        this.closeButton = new eJButton(closeAction);
        this.closeButton.setBackground(UISettings.CLOSEBUTTON_COLOR);
        this.closeButton.setForeground(UISettings.CLOSEBUTTON_TEXT_COLOR);
        this.closeButton.setFocusPainted(false);
        this.closeButton.setFont(UISettings.BUTTON_FONT);
        this.titleBar.add((Component)this.closeButton, "East");
    }

    private void addPathBar() {
        JPanel pathBar = new JPanel();
        pathBar.setLayout(new BorderLayout(0, 0));
        pathBar.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.add((Component)pathBar, "Center");
        JTextArea pathDisplayComponent = new JTextArea();
        pathBar.add((Component)pathDisplayComponent, "Center");
        pathDisplayComponent.setBackground(pathBar.getBackground());
        pathDisplayComponent.setText(PATH_INIT_TEXT);
        pathDisplayComponent.setEditable(false);
        GUIAction editAction = new GUIAction(EDIT_BUTTON_TEXT, null, new EditCommand(this.controller));
        eJButton editButton = new eJButton(editAction);
        editButton.setBackground(UISettings.EDITBUTTON_COLOR);
        editButton.setForeground(UISettings.EDITBUTTON_TEXT_COLOR);
        editButton.setFocusPainted(false);
        editButton.setFont(UISettings.BUTTON_FONT);
        editButton.setPreferredSize(this.closeButton.getPreferredSize());
        editButton.setMinimumSize(this.closeButton.getMinimumSize());
        editButton.setMaximumSize(this.closeButton.getMaximumSize());
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(Box.createVerticalGlue());
        buttonBox.add(editButton);
        buttonBox.add(Box.createVerticalGlue());
        pathBar.add((Component)buttonBox, "East");
    }

    private void addBottomLine() {
        JPanel bottomLine = new JPanel();
        bottomLine.setPreferredSize(UISettings.HEADER_BOTTOMLINE_DIMS);
        bottomLine.setBackground(UISettings.BOTTOMLINE_COLOR);
        bottomLine.setOpaque(true);
        this.add((Component)bottomLine, "South");
    }

    protected void setBackButtonEnabled(boolean enabled) {
        this.backButton.setEnabled(enabled);
        this.titleBar.invalidate();
    }

    protected void setTitleBarColor(Color color) {
        this.titleBar.setBackground(color);
        this.titleBar.invalidate();
    }

    protected void setTitleBarText(String text) {
        this.titleTextLabel.setText(text);
        this.titleTextLabel.invalidate();
    }

    class eJButton
    extends JButton {
        eJButton(Action a) {
            super(a);
            super.setUI(new MetalButtonUI());
            UIManager.put("Button.disabledText", UISettings.BUTTON_DISABLED_TEXT_COLOR);
            UIManager.put("Button.margin", UISettings.METAVIEW_BUTTON_INSETS);
            this.updateUI();
        }
    }
}

