/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.ReferencesHandler;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DataPackageWizardPlugin;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.PartyPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Node;

public class PartyMainPage
extends AbstractUIPage {
    private String pageID;
    private String nextPageID;
    private String pageNumber;
    private String subtitle;
    private String description;
    private String xPathRoot;
    private String DATAPACKAGE_PARTY_GENERIC_NAME;
    private String DATAPACKAGE_PARTY_REL_XPATH;
    private final String[] colNames = new String[]{"Party", "Role", "Address"};
    private final Object[] editors = null;
    public final String title = "People or Organizations Associated With This Data Package";
    public final String role;
    private JLabel minRequiredLabel;
    private CustomList partiesList;
    private boolean oneOrMoreRequired;
    private OrderedMap returnMap = new OrderedMap();

    public PartyMainPage(String role) {
        this.role = role;
        this.initRole();
        this.init();
    }

    private void initRole() {
        if (this.role.equals("PARTY_CREATOR")) {
            this.oneOrMoreRequired = true;
            this.pageID = "PARTY_CREATOR_PAGE";
            this.nextPageID = "PARTY_CONTACT_PAGE";
            this.pageNumber = "5";
            this.subtitle = "Owners";
            this.xPathRoot = "/eml:eml/dataset/creator[";
            this.DATAPACKAGE_PARTY_GENERIC_NAME = "creator";
            this.DATAPACKAGE_PARTY_REL_XPATH = "/creator[";
            this.description = "<p><b>Enter information about the Owners</b>: This is information about the persons or organizations certified as data owners (e.g. the principal investigator(s) of the project). The list of data owners should include all people and organizations who should be cited for the data. Select Add to add an owner.<br></br></p>";
        } else if (this.role.equals("PARTY_CONTACT")) {
            this.oneOrMoreRequired = true;
            this.pageID = "PARTY_CONTACT_PAGE";
            this.nextPageID = "PARTY_ASSOCIATED_PAGE";
            this.pageNumber = "6";
            this.subtitle = "Contacts";
            this.xPathRoot = "/eml:eml/dataset/contact[";
            this.DATAPACKAGE_PARTY_GENERIC_NAME = "contact";
            this.DATAPACKAGE_PARTY_REL_XPATH = "/contact[";
            this.description = "<p><b>Enter information about contacts</b>. This is information about the people or organizations who would be contacted with questions about the use or interpretation of a data package. <br></br></p>";
        } else if (this.role.equals("PARTY_ASSOCIATED")) {
            this.oneOrMoreRequired = false;
            this.pageID = "PARTY_ASSOCIATED_PAGE";
            this.nextPageID = "PROJECT";
            this.pageNumber = "7";
            this.subtitle = "Associated Parties";
            this.xPathRoot = "/eml:eml/dataset/associatedParty[";
            this.DATAPACKAGE_PARTY_GENERIC_NAME = "associatedParty";
            this.DATAPACKAGE_PARTY_REL_XPATH = "/associatedParty[";
            this.description = "<p><b>Enter associated parties information</b>.  These are persons or organizations functionally associated with the dataset. Enter the nature of the relationship in the role field. For example, the person who maintains the database is an associated party with the role of 'custodian'.<br></br><p>";
        } else {
            Log.debug(5, "Unrecognized role parameter passed to PartyPage: " + this.role);
            return;
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JLabel desc = WidgetFactory.makeHTMLLabel(this.description, 4);
        this.add((Component)desc, "North");
        JPanel vPanel = WidgetFactory.makeVerticalPanel(6);
        if (this.oneOrMoreRequired) {
            this.minRequiredLabel = WidgetFactory.makeLabel(" One or more " + this.subtitle + " must be defined:", true, WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS);
            vPanel.add(this.minRequiredLabel);
        }
        this.partiesList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.partiesList.setBorder(new EmptyBorder(0, 5, 5, 10));
        vPanel.add(WidgetFactory.makeDefaultSpacer());
        vPanel.add(this.partiesList);
        vPanel.add(WidgetFactory.makeDefaultSpacer());
        this.add((Component)vPanel, "Center");
        this.initActions();
    }

    private void initActions() {
        this.partiesList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nPartyPage: CustomAddAction called");
                PartyMainPage.this.showNewPartyDialog();
            }
        });
        this.partiesList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nPartyPage: CustomEditAction called");
                PartyMainPage.this.showEditPartyDialog();
            }
        });
        this.partiesList.setCustomDeleteAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nPartyPage: CustomDeleteAction called");
                PartyMainPage.this.deleteParty((CustomList)e.getSource());
            }
        });
    }

    private void showNewPartyDialog() {
        PartyPage partyPage = (PartyPage)WizardPageLibrary.getPage(this.role);
        ModalDialog wpd = new ModalDialog(partyPage, WizardContainerFrame.getDialogParent(), 770, 570);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = partyPage.getSurrogate();
            newRow.add(partyPage);
            this.partiesList.addRow(newRow);
            if (partyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(partyPage);
            }
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        }
        if (this.oneOrMoreRequired) {
            WidgetFactory.unhiliteComponent(this.minRequiredLabel);
        }
    }

    private void updateOriginalRefPartyPage(PartyPage partyPage) {
        String originalRefID = partyPage.getReferencesNodeIDString();
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot update!");
            return;
        }
        List nextRowList2 = null;
        PartyPage nextPage = null;
        for (List nextRowList2 : this.partiesList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPage = (PartyPage)nextRowList2.get(3)) == partyPage || nextPage == null || !nextPage.getRefID().equals(originalRefID)) continue;
            Node root = adp.getSubtreeAtReference(originalRefID);
            OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)root);
            Log.debug(45, "updateOriginalRefPartyPage() got a match with ID: " + originalRefID + "; map = " + map);
            if (map == null || map.isEmpty()) {
                return;
            }
            boolean checkParty = nextPage.setPageData(map, "/" + this.DATAPACKAGE_PARTY_GENERIC_NAME);
        }
    }

    private void showEditPartyDialog() {
        List selRowList = this.partiesList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 4) {
            return;
        }
        Object dialogObj = selRowList.get(3);
        if (dialogObj == null || !(dialogObj instanceof PartyPage)) {
            return;
        }
        PartyPage editPartyPage = (PartyPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editPartyPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editPartyPage.getSurrogate();
            newRow.add(editPartyPage);
            this.partiesList.replaceSelectedRow(newRow);
            if (editPartyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(editPartyPage);
            }
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        }
    }

    private void deleteParty(CustomList list) {
        if (list == null) {
            Log.debug(15, "**ERROR: deleteParty() received NULL CustomList");
            return;
        }
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot delete!");
            return;
        }
        Log.debug(45, "BEFORE: adp=" + adp);
        List[] deletedRows = list.getSelectedRows();
        int userObjIdx = deletedRows[0].size() - 1;
        for (int i = 0; i < deletedRows.length; ++i) {
            PartyPage page = (PartyPage)deletedRows[i].get(userObjIdx);
            Node retval = ReferencesHandler.deleteOriginalReferenceSubtree(adp, page.getRefID());
            if (retval != null) continue;
            this.partiesList.removeRow(this.partiesList.getSelectedRowIndex());
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        }
        Log.debug(45, "AFTER: adp=" + adp);
        if (this.oneOrMoreRequired) {
            WidgetFactory.unhiliteComponent(this.minRequiredLabel);
        }
        DataPackageWizardPlugin.updatePartiesListFromDOM(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
    }

    public void onLoadAction() {
        DataPackageWizardPlugin.updatePartiesListFromDOM(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        this.partiesList.focusAddButton();
    }

    public void onRewindAction() {
        if (this.oneOrMoreRequired) {
            WidgetFactory.unhiliteComponent(this.minRequiredLabel);
        }
        DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
    }

    public boolean onAdvanceAction() {
        if (this.oneOrMoreRequired && this.partiesList.getRowCount() < 1) {
            WidgetFactory.hiliteComponent(this.minRequiredLabel);
            return false;
        }
        DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String rootXPath) {
        this.returnMap.clear();
        DataPackageWizardPlugin.updatePartiesListFromDOM(this.partiesList, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.DATAPACKAGE_PARTY_GENERIC_NAME, this.role);
        int index = 1;
        List nextRowList2 = null;
        OrderedMap nextNVPMap = null;
        PartyPage nextPartyPage = null;
        for (List nextRowList2 : this.partiesList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPartyPage = (PartyPage)nextRowList2.get(3)) == null) continue;
            nextNVPMap = nextPartyPage.getPageData(rootXPath + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        return this.returnMap;
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "People or Organizations Associated With This Data Package";
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.partiesList.removeAllRows();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        ArrayList partyList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Party:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            if (!nextXPath.startsWith(this.DATAPACKAGE_PARTY_REL_XPATH)) continue;
            Log.debug(45, ">>>>>>>>>> adding to partysetList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
            this.addToPartySet(nextXPathObj, nextValObj, partyList);
            toDeleteList.add(nextXPathObj);
        }
        Iterator persIt = partyList.iterator();
        Object nextStepMapObj = null;
        OrderedMap nextStepMap = null;
        boolean partyPredicate = true;
        this.partiesList.removeAllRows();
        boolean partyRetVal = true;
        while (persIt.hasNext()) {
            nextStepMapObj = persIt.next();
            if (nextStepMapObj == null || (nextStepMap = (OrderedMap)nextStepMapObj).isEmpty()) continue;
            PartyPage nextStep = (PartyPage)WizardPageLibrary.getPage(this.role);
            boolean checkMethod = nextStep.setPageData(map, "/" + this.DATAPACKAGE_PARTY_GENERIC_NAME);
            if (!checkMethod) {
                partyRetVal = false;
            }
            List newRow = nextStep.getSurrogate();
            newRow.add(nextStep);
            this.partiesList.addRow(newRow);
        }
        if (!partyRetVal) {
            Log.debug(20, "Keyword.setPageData - Method sub-class returned FALSE");
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Keyword.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal && partyRetVal;
    }

    private void addToPartySet(Object nextPersonnelXPathObj, Object nextPersonnelVal, List partyList) {
        if (nextPersonnelXPathObj == null) {
            return;
        }
        String nextPersonnelXPath = (String)nextPersonnelXPathObj;
        int predicate = this.getFirstPredicate(nextPersonnelXPath, this.DATAPACKAGE_PARTY_REL_XPATH);
        if (predicate >= partyList.size()) {
            for (int i = partyList.size(); i <= predicate; ++i) {
                partyList.add(new OrderedMap());
            }
        }
        if (predicate < partyList.size()) {
            Object nextMapObj = partyList.get(predicate);
            OrderedMap nextMap = (OrderedMap)nextMapObj;
            nextMap.put(nextPersonnelXPathObj, nextPersonnelVal);
        } else {
            Log.debug(15, "**** ERROR - KeywordsaddToKeywordSet() - predicate > partySet.size()");
        }
    }

    private int getFirstPredicate(String xpath, String firstSegment) {
        String tempXPath = xpath.substring(xpath.indexOf(firstSegment) + firstSegment.length());
        return Integer.parseInt(tempXPath.substring(0, tempXPath.indexOf("]")));
    }
}

