/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.MethodsPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class Methods
extends AbstractUIPage {
    private final String pageID = "METHODS";
    private final String nextPageID = "ACCESS";
    private final String title = "Methods and Sampling";
    private final String subtitle = "";
    private final String pageNumber = "13";
    private final String EMPTY_STRING = "";
    private final String METHOD_ROOT = "methods/";
    private final String XPATH_ROOT = "/eml:eml/dataset[1]/methods/";
    private final String STUDY_REL_XPATH = "sampling[1]/studyExtent[1]/description[1]/para[1]";
    private final String SAMPLING_REL_XPATH = "sampling[1]/samplingDescription[1]/para[1]";
    private final String METHODSTEP_REL_XPATH = "methodStep[";
    private String xPathRoot = "methods/";
    private JTextArea studyArea;
    private JTextArea sampleArea;
    private JLabel studyLabel;
    private JLabel sampleLabel;
    private JLabel warningLabel;
    private JPanel warningPanel;
    private static final Dimension FULL_LABEL_DIMS = new Dimension(700, 20);
    private final String[] colNames = new String[]{"Method Step Title", "Method Step Description", "Instrumentation"};
    private final Object[] editors = null;
    private CustomList methodsList;
    private OrderedMap returnMap = new OrderedMap();

    public Methods() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Methods vbox = this;
        vbox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc1 = WidgetFactory.makeHTMLLabel("<p><b>Enter method step description.</b> Method steps describe a single step in the implementation of a methodology for an experiment.</p>", 1);
        vbox.add(desc1);
        vbox.add(WidgetFactory.makeHalfSpacer());
        this.methodsList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.methodsList.setBorder(new EmptyBorder(0, 5, 0, 0));
        vbox.add(this.methodsList);
        JLabel studyDesc = WidgetFactory.makeHTMLLabel("<p><b>Study extent description</b>. Describe the temporal, spatial and taxonomic extent of the study.  This information supplements the coverage information you may have provided in a previous step.</p>", 3);
        vbox.add(studyDesc);
        JPanel studyPanel = WidgetFactory.makePanel(10);
        this.studyLabel = WidgetFactory.makeLabel(" Study Extent", false);
        studyPanel.add(this.studyLabel);
        this.studyArea = WidgetFactory.makeTextArea("", 3, true);
        JScrollPane jStudyScrl = new JScrollPane(this.studyArea);
        studyPanel.add(jStudyScrl);
        vbox.add(studyPanel);
        JLabel sampleDesc = WidgetFactory.makeHTMLLabel("<b>Sampling description</b>. Describe the sampling design of the study. For example, you might describe the way in which treatments were assigned to sampling units.", 2);
        vbox.add(sampleDesc);
        JPanel samplePanel = WidgetFactory.makePanel(10);
        this.sampleLabel = WidgetFactory.makeLabel(" Sampling", false);
        samplePanel.add(this.sampleLabel);
        this.sampleArea = WidgetFactory.makeTextArea("", 3, true);
        JScrollPane jSampleScrl = new JScrollPane(this.sampleArea);
        samplePanel.add(jSampleScrl);
        vbox.add(samplePanel);
        this.warningPanel = WidgetFactory.makePanel(1);
        this.warningLabel = WidgetFactory.makeLabel("Warning: at least one of the three entries is required: Last Name, Position Name or Organization", true);
        this.warningPanel.add(this.warningLabel);
        this.warningPanel.setVisible(false);
        this.setPrefMinMaxSizes(this.warningLabel, FULL_LABEL_DIMS);
        this.warningPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        vbox.add(this.warningPanel);
        this.initActions();
    }

    private void initActions() {
        this.methodsList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nMethods: CustomAddAction called");
                Methods.this.showNewMethodsDialog();
            }
        });
        this.methodsList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nMethods: CustomEditAction called");
                Methods.this.showEditMethodsDialog();
            }
        });
    }

    private void showNewMethodsDialog() {
        MethodsPage methodsPage = (MethodsPage)WizardPageLibrary.getPage("METHODS_PAGE");
        ModalDialog wpd = new ModalDialog(methodsPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = methodsPage.getSurrogate();
            newRow.add(methodsPage);
            this.methodsList.addRow(newRow);
        }
    }

    private void showEditMethodsDialog() {
        List selRowList = this.methodsList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 4) {
            return;
        }
        Object dialogObj = selRowList.get(3);
        if (dialogObj == null || !(dialogObj instanceof MethodsPage)) {
            return;
        }
        MethodsPage editMethodsPage = (MethodsPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editMethodsPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editMethodsPage.getSurrogate();
            newRow.add(editMethodsPage);
            this.methodsList.replaceSelectedRow(newRow);
        }
    }

    private void setPrefMinMaxSizes(JComponent component, Dimension dims) {
        WidgetFactory.setPrefMaxSizes(component, dims);
        component.setMinimumSize(dims);
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.methodsList.getRowCount() == 0 && (this.studyArea.getText().trim().compareTo("") != 0 || this.sampleArea.getText().trim().compareTo("") != 0)) {
            this.warningLabel.setText("Method steps are required if you provide either a study extent or smapling description");
            this.warningPanel.setVisible(true);
            return false;
        }
        if (this.studyArea.getText().trim().compareTo("") == 0 && this.sampleArea.getText().trim().compareTo("") != 0) {
            this.warningLabel.setText("Study extent is required if you provide sampling description");
            this.warningPanel.setVisible(true);
            return false;
        }
        if (this.studyArea.getText().trim().compareTo("") != 0 && this.sampleArea.getText().trim().compareTo("") == 0) {
            this.warningLabel.setText("Sampling description is required if you provide study extent");
            this.warningPanel.setVisible(true);
            return false;
        }
        this.warningPanel.setVisible(false);
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData("/eml:eml/dataset[1]/methods/");
    }

    public OrderedMap getPageData(String rootXPath) {
        String sample;
        this.returnMap.clear();
        int index = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        MethodsPage nextMethodsPage = null;
        List rowLists = this.methodsList.getListOfRowLists();
        if (rowLists != null && rowLists.isEmpty()) {
            return this.returnMap;
        }
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 4 || (nextUserObject = nextRowList.get(3)) == null) continue;
            nextMethodsPage = nextUserObject;
            nextNVPMap = nextMethodsPage.getPageData(rootXPath + "methodStep[" + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        String study = this.studyArea.getText().trim();
        if (study != null && !study.equals("")) {
            this.returnMap.put((Object)(rootXPath + "sampling[1]/studyExtent[1]/description[1]/para[1]"), (Object)study);
        }
        if ((sample = this.sampleArea.getText().trim()) != null && !sample.equals("")) {
            this.returnMap.put((Object)(rootXPath + "sampling[1]/samplingDescription[1]/para[1]"), (Object)sample);
        }
        return this.returnMap;
    }

    public String getPageID() {
        return "METHODS";
    }

    public String getTitle() {
        return "Methods and Sampling";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "ACCESS";
    }

    public String getPageNumber() {
        return "13";
    }

    private void resetBlankData() {
        this.studyArea.setText("");
        this.sampleArea.setText("");
        this.methodsList.removeAllRows();
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.resetBlankData();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        ArrayList methodstepList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Methods:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            nextXPath = nextXPath.substring(nextXPath.lastIndexOf(this.xPathRoot) + this.xPathRoot.length());
            Log.debug(45, "Methods: TRIMMED nextXPath   = " + nextXPath);
            if (nextXPath.startsWith("sampling[1]/samplingDescription[1]/para[1]")) {
                this.sampleArea.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("sampling[1]/studyExtent[1]/description[1]/para[1]")) {
                this.studyArea.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("methodStep[")) continue;
            Log.debug(45, ">>>>>>>>>> adding to methodstepList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
            this.addToMethodStep(nextXPathObj, nextValObj, methodstepList);
            toDeleteList.add(nextXPathObj);
        }
        Iterator persIt = methodstepList.iterator();
        Object nextStepMapObj = null;
        OrderedMap nextStepMap = null;
        int methodPredicate = 1;
        this.methodsList.removeAllRows();
        boolean methodRetVal = true;
        while (persIt.hasNext()) {
            nextStepMapObj = persIt.next();
            if (nextStepMapObj == null || (nextStepMap = (OrderedMap)nextStepMapObj).isEmpty()) continue;
            MethodsPage nextStep = (MethodsPage)WizardPageLibrary.getPage("METHODS_PAGE");
            boolean checkMethod = nextStep.setPageData(nextStepMap, this.xPathRoot + "methodStep[" + methodPredicate++ + "]/");
            if (!checkMethod) {
                methodRetVal = false;
            }
            List newRow = nextStep.getSurrogate();
            newRow.add(nextStep);
            this.methodsList.addRow(newRow);
        }
        if (!methodRetVal) {
            Log.debug(20, "Methods.setPageData - Method sub-class returned FALSE");
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Project.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal && methodRetVal;
    }

    private void addToMethodStep(Object nextPersonnelXPathObj, Object nextPersonnelVal, List methodstepList) {
        if (nextPersonnelXPathObj == null) {
            return;
        }
        String nextPersonnelXPath = (String)nextPersonnelXPathObj;
        int predicate = this.getFirstPredicate(nextPersonnelXPath, "methodStep[");
        if (predicate >= methodstepList.size()) {
            for (int i = methodstepList.size(); i <= predicate; ++i) {
                methodstepList.add(new OrderedMap());
            }
        }
        if (predicate < methodstepList.size()) {
            Object nextMapObj = methodstepList.get(predicate);
            OrderedMap nextMap = (OrderedMap)nextMapObj;
            nextMap.put(nextPersonnelXPathObj, nextPersonnelVal);
        } else {
            Log.debug(15, "**** ERROR - Methods.addToMethodStep() - predicate > methodstepList.size()");
        }
    }

    private int getFirstPredicate(String xpath, String firstSegment) {
        String tempXPath = xpath.substring(xpath.indexOf(firstSegment) + firstSegment.length());
        return Integer.parseInt(tempXPath.substring(0, tempXPath.indexOf("]")));
    }
}

