/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CitationPage;
import edu.ucsb.nceas.utilities.OrderedMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class BookPanel
extends JPanel
implements WizardPageSubPanelAPI {
    CitationPage parent;
    private JLabel editionLabel;
    private JLabel volumeLabel;
    private JLabel publisherLabel;
    private JLabel isbnLabel;
    private JTextField editionField;
    private JTextField volumeField;
    private JTextField publisherField;
    private JTextField isbnField;

    BookPanel(CitationPage page) {
        this.parent = page;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel publisherPanel = WidgetFactory.makePanel(1);
        this.publisherLabel = WidgetFactory.makeLabel("Publisher:", true);
        publisherPanel.add(this.publisherLabel);
        this.publisherField = WidgetFactory.makeOneLineTextField();
        publisherPanel.add(this.publisherField);
        publisherPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(publisherPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel editionPanel = WidgetFactory.makePanel(1);
        this.editionLabel = WidgetFactory.makeLabel("Edition:", false);
        editionPanel.add(this.editionLabel);
        this.editionField = WidgetFactory.makeOneLineTextField();
        editionPanel.add(this.editionField);
        editionPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(editionPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel volumePanel = WidgetFactory.makePanel(1);
        this.volumeLabel = WidgetFactory.makeLabel("Volume:", false);
        volumePanel.add(this.volumeLabel);
        this.volumeField = WidgetFactory.makeOneLineTextField();
        volumePanel.add(this.volumeField);
        volumePanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(volumePanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel isbnPanel = WidgetFactory.makePanel(1);
        this.isbnLabel = WidgetFactory.makeLabel("ISBN:", false);
        isbnPanel.add(this.isbnLabel);
        this.isbnField = WidgetFactory.makeOneLineTextField();
        isbnPanel.add(this.isbnField);
        isbnPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(isbnPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
    }

    public boolean validateUserInput() {
        String text = this.publisherField.getText();
        if (text.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.publisherLabel);
            this.publisherField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.publisherLabel);
        return true;
    }

    public void onLoadAction() {
    }

    public OrderedMap getPanelData(String xPathRoot) {
        String isbn;
        String vn;
        OrderedMap map = new OrderedMap();
        String publisher = this.publisherField.getText().trim();
        map.put((Object)(xPathRoot + "/publisher[1]/organizationName[1]"), (Object)publisher);
        String en = this.editionField.getText();
        if (!en.trim().equals("")) {
            map.put((Object)(xPathRoot + "/edition[1]"), (Object)en);
        }
        if (!(vn = this.volumeField.getText()).trim().equals("")) {
            map.put((Object)(xPathRoot + "/volume[1]"), (Object)vn);
        }
        if (!(isbn = this.isbnField.getText()).trim().equals("")) {
            map.put((Object)(xPathRoot + "/ISBN[1]"), (Object)isbn);
        }
        return map;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String isbn;
        String vn;
        String en;
        String pub = (String)map.get((Object)(xPathRoot + "/publisher[1]/organizationName[1]"));
        if (pub != null) {
            this.publisherField.setText(pub);
            map.remove((Object)(xPathRoot + "/publisher[1]/organizationName[1]"));
        }
        if ((en = (String)map.get((Object)(xPathRoot + "/edition[1]"))) != null) {
            this.editionField.setText(en);
            map.remove((Object)(xPathRoot + "/edition[1]"));
        }
        if ((vn = (String)map.get((Object)(xPathRoot + "/volume[1]"))) != null) {
            this.volumeField.setText(vn);
            map.remove((Object)(xPathRoot + "/volume[1]"));
        }
        if ((isbn = (String)map.get((Object)(xPathRoot + "/ISBN[1]"))) != null) {
            this.isbnField.setText(isbn);
            map.remove((Object)(xPathRoot + "/ISBN[1]"));
        }
    }
}

