/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datastore;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datastore.DataStore;
import edu.ucsb.nceas.morpho.datastore.DataStoreInterface;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.Reader;

public class FileSystemDataStore
extends DataStore
implements DataStoreInterface {
    public FileSystemDataStore(Morpho morpho) {
        super(morpho);
    }

    public File openFile(String name) throws FileNotFoundException {
        String path = this.parseId(name);
        path = this.datadir + "/" + path;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("file " + path + " does not exist");
        }
        return file;
    }

    public File saveFile(String name, Reader file) {
        return this.saveFile(name, file, this.datadir);
    }

    public File saveTempFile(String name, Reader file) {
        return this.saveFile(name, file, this.tempdir);
    }

    public File openTempFile(String name) throws FileNotFoundException {
        Log.debug(21, "opening " + name + " from temp dir - temp: " + this.tempdir);
        File file = new File(this.tempdir + "/" + name);
        if (!file.exists()) {
            throw new FileNotFoundException("file " + this.tempdir + "/" + name + " does not exist");
        }
        return file;
    }

    public File saveDataFile(String name, Reader file) {
        return this.saveDataFile(name, file, this.datadir);
    }

    public File saveTempDataFile(String name, Reader file) {
        return this.saveDataFile(name, file, this.tempdir);
    }

    public File saveDataFile(String name, InputStream file) {
        return this.saveDataFile(name, file, this.datadir);
    }

    public File saveTempDataFile(String name, InputStream file) {
        return this.saveDataFile(name, file, this.tempdir);
    }

    public File saveFile(String name, Reader file, String rootDir) {
        BufferedWriter bwriter = null;
        BufferedReader bsr = null;
        try {
            String path = this.parseId(name);
            String dirs = path.substring(0, path.lastIndexOf("/"));
            File savefile = new File(rootDir + "/" + path);
            File savedir = new File(rootDir + "/" + dirs);
            if (!savefile.exists()) {
                try {
                    savedir.mkdirs();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            bsr = new BufferedReader(file);
            bwriter = new BufferedWriter(new FileWriter(savefile));
            int d = bsr.read();
            while (d != -1) {
                bwriter.write(d);
                d = bsr.read();
            }
            bsr.close();
            bwriter.flush();
            bwriter.close();
            return savefile;
        }
        catch (Exception e) {
            if (bwriter != null) {
                try {
                    if (bsr != null) {
                        bsr.close();
                    }
                    if (bwriter != null) {
                        bwriter.close();
                    }
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    public File newFile(String name, Reader file) {
        return this.saveFile(name, file, this.datadir);
    }

    public File newDataFile(String name, InputStream is) {
        return this.saveDataFile(name, is, this.datadir);
    }

    public boolean deleteFile(String name) {
        String path = this.parseId(name);
        String filePath = this.datadir + "/" + path;
        File delfile = new File(filePath);
        boolean success = false;
        try {
            success = delfile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("the success value is " + success);
        return success;
    }

    public static void main(String[] args) {
        String filename = args[0];
        String filename2 = args[1];
        String action = args[2];
        if (action.equals("test")) {
            try {
                Morpho morpho = new Morpho(new ConfigXML("./lib/config.xml"));
                FileSystemDataStore fsds = new FileSystemDataStore(morpho);
                File newfile = fsds.openFile(filename);
                fsds.saveFile(filename2, new FileReader(newfile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (action.equals("save")) {
            try {
                Morpho morpho = new Morpho(new ConfigXML("./lib/config.xml"));
                FileSystemDataStore fsds = new FileSystemDataStore(morpho);
                File newfile = new File(filename);
                fsds.saveFile(filename2, new FileReader(newfile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.debug(20, "done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveDataFile(String name, Reader file, String rootDir) {
        BufferedWriter bwriter = null;
        BufferedReader bfile = null;
        try {
            String path = this.parseId(name);
            String dirs = path.substring(0, path.lastIndexOf("/"));
            File savefile = new File(rootDir + "/" + path);
            File savedir = new File(rootDir + "/" + dirs);
            if (!savefile.exists()) {
                try {
                    savedir.mkdirs();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            bfile = new BufferedReader(file);
            bwriter = new BufferedWriter(new FileWriter(savefile));
            int d = bfile.read();
            while (d != -1) {
                bwriter.write(d);
                d = bfile.read();
            }
            bfile.close();
            bwriter.flush();
            bwriter.close();
            File file2 = savefile;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file3 = null;
            return file3;
        }
        finally {
            try {
                if (bfile != null) {
                    bfile.close();
                }
                if (bwriter != null) {
                    bwriter.flush();
                }
                if (bwriter != null) {
                    bwriter.close();
                }
            }
            catch (Exception t) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveDataFile(String name, InputStream file, String rootDir) {
        BufferedInputStream bfile = null;
        FilterOutputStream bos = null;
        try {
            String path = this.parseId(name);
            String dirs = path.substring(0, path.lastIndexOf("/"));
            File savefile = new File(rootDir + "/" + path);
            File savedir = new File(rootDir + "/" + dirs);
            if (!savefile.exists()) {
                try {
                    savedir.mkdirs();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            bfile = new BufferedInputStream(file);
            bos = new BufferedOutputStream(new FileOutputStream(savefile));
            int d = bfile.read();
            while (d != -1) {
                ((BufferedOutputStream)bos).write(d);
                d = bfile.read();
            }
            ((BufferedOutputStream)bos).flush();
            bos.close();
            bfile.close();
            File file2 = savefile;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file3 = null;
            return file3;
        }
        finally {
            try {
                if (bfile != null) {
                    bfile.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception r) {}
        }
    }
}

