/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

public class TableCutCommand
implements Command {
    protected JTable source;
    private MorphoFrame morphoFrame = null;

    public void setSource(JTable tbl) {
        this.source = tbl;
    }

    public JTable getSource() {
        return this.source;
    }

    public void execute(ActionEvent event) {
        JTable jtable;
        DataViewer dataView;
        DataViewContainerPanel resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null && (dataView = resultPane.getCurrentDataViewer()) != null && dataView.getTextFlag() && (jtable = dataView.getDataTable()) != null) {
            this.setSource(jtable);
            this.cut(event);
        }
    }

    private void cut(ActionEvent evt) {
        JTable tbl = this.source;
        if (tbl == null) {
            tbl = (JTable)evt.getSource();
        }
        int minRow = -1;
        int maxRow = -1;
        int minCol = -1;
        int maxCol = -1;
        ListSelectionModel rowModel = tbl.getSelectionModel();
        ListSelectionModel colModel = tbl.getColumnModel().getSelectionModel();
        if (tbl.getCellSelectionEnabled()) {
            minRow = rowModel.getMinSelectionIndex();
            maxRow = rowModel.getMaxSelectionIndex();
            minCol = colModel.getMinSelectionIndex();
            maxCol = colModel.getMaxSelectionIndex();
        } else if (tbl.getRowSelectionAllowed()) {
            minRow = rowModel.getMinSelectionIndex();
            maxRow = rowModel.getMaxSelectionIndex();
            minCol = 0;
            maxCol = tbl.getColumnCount() - 1;
        } else if (tbl.getColumnSelectionAllowed()) {
            minRow = 0;
            maxRow = tbl.getRowCount() - 1;
            minCol = colModel.getMinSelectionIndex();
            maxCol = colModel.getMaxSelectionIndex();
        }
        if (minRow == -1 || minCol == -1) {
            return;
        }
        boolean isEmpty = true;
        StringBuffer sel = new StringBuffer();
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                if (!tbl.isCellSelected(row, col)) continue;
                if (col == minCol && row != minRow) {
                    sel.append('\n');
                } else if (col != minCol) {
                    sel.append('\t');
                }
                sel.append(this.getValueAt(tbl, row, col));
                this.clearValueAt(tbl, row, col);
                isEmpty = false;
            }
        }
        ((AbstractTableModel)tbl.getModel()).fireTableStructureChanged();
        if (!isEmpty) {
            tbl.getToolkit().getSystemClipboard().setContents(new StringSelection(sel.toString()), null);
            StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(tbl, StateChangeEvent.CLIPBOARD_HAS_DATA_TO_PASTE));
        }
    }

    protected String getValueAt(JTable tbl, int row, int col) {
        return tbl.getValueAt(row, col).toString();
    }

    protected void clearValueAt(JTable tbl, int row, int col) {
        tbl.setValueAt("", row, col);
    }
}

