/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddTemporalCovCommand
implements Command {
    private boolean infoAddFlag = false;
    private MorphoFrame morphoFrame = null;
    private DataViewContainerPanel resultPane;
    private AbstractUIPage temporalPage;
    private AbstractDataPackage adp;
    private Node covRoot;
    private Set mapSet;
    private Iterator mapSetIt;
    private Object key;
    private OrderedMap map;
    private OrderedMap newMap;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        this.resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            this.resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (this.resultPane != null) {
            this.showTemporalDialog();
            if (this.infoAddFlag) {
                try {
                    this.adp.removeTemporalNodes();
                    this.insertNewTemporal();
                    UIController.showNewPackage(this.adp);
                }
                catch (Exception w) {
                    Log.debug(20, "Exception trying to modify coverage DOM");
                }
            }
        }
    }

    private void showTemporalDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
        }
        if (dpwPlugin == null) {
            return;
        }
        this.temporalPage = dpwPlugin.getPage("TEMPORAL");
        ModalDialog wpd = new ModalDialog(this.temporalPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570, false);
        boolean pageCanHandleAllData = this.insertCurrentData();
        if (pageCanHandleAllData) {
            wpd.setSize(770, 570);
            wpd.setVisible(true);
            this.infoAddFlag = wpd.USER_RESPONSE == 10;
        } else {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("coverage", 0);
        }
    }

    private void insertNewTemporal() {
        this.covRoot = null;
        this.map = this.temporalPage.getPageData("/coverage/temporalCoverage[");
        this.adp = this.resultPane.getAbstractDataPackage();
        try {
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "coverage", null);
            this.covRoot = doc.getDocumentElement();
            XMLUtilities.getXPathMapAsDOMTree((Map)this.map, (Node)this.covRoot);
            NodeList kids = this.covRoot.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node kid = kids.item(i);
                this.adp.insertCoverage(kid);
            }
        }
        catch (Exception w) {
            Log.debug(5, "Unable to add OrderMap elements to DOM");
            w.printStackTrace();
        }
    }

    private boolean insertCurrentData() {
        boolean res = true;
        NodeList tempList = this.adp.getTemporalNodeList();
        if (tempList == null) {
            return true;
        }
        for (int i = 0; i < tempList.getLength(); ++i) {
            OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap((Node)tempList.item(i));
            boolean flag = true;
            flag = i == 0 ? this.temporalPage.setPageData(tempMap, "removeAllRows") : this.temporalPage.setPageData(tempMap, "");
            if (flag) continue;
            res = false;
        }
        return res;
    }
}

